/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.Optional;
import org.activiti.cloud.alfresco.data.domain.AlfrescoPagedModelAssembler;
import org.activiti.cloud.api.model.shared.QueryCloudVariableInstance;
import org.activiti.cloud.services.query.app.repository.TaskVariableRepository;
import org.activiti.cloud.services.query.model.QTaskVariableEntity;
import org.activiti.cloud.services.query.model.TaskVariableEntity;
import org.activiti.cloud.services.query.rest.assembler.QueryCloudTaskVariableInstanceRepresentationModelAssembler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.querydsl.binding.QuerydslPredicate;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/tasks/{td}/variables"}, produces={"application/hal+json", "application/json"})
public class TaskVariableController {
    private final TaskVariableRepository variableRepository;
    private QueryCloudTaskVariableInstanceRepresentationModelAssembler variableRepresentationModelAssembler;
    private AlfrescoPagedModelAssembler<TaskVariableEntity> pagedCollectionModelAssembler;

    @Autowired
    public TaskVariableController(TaskVariableRepository variableRepository, QueryCloudTaskVariableInstanceRepresentationModelAssembler variableRepresentationModelAssembler, AlfrescoPagedModelAssembler<TaskVariableEntity> pagedCollectionModelAssembler) {
        this.variableRepository = variableRepository;
        this.variableRepresentationModelAssembler = variableRepresentationModelAssembler;
        this.pagedCollectionModelAssembler = pagedCollectionModelAssembler;
    }

    @RequestMapping(method={RequestMethod.GET})
    public PagedModel<EntityModel<QueryCloudVariableInstance>> getVariablesTask(@PathVariable String td, @Parameter(description="Predicate binding to core entity parameter values.", example="{\"name\": \"Real name\"}") @QuerydslPredicate(root=TaskVariableEntity.class) Predicate predicate, Pageable pageable) {
        predicate = Optional.ofNullable(predicate).orElseGet(BooleanBuilder::new);
        QTaskVariableEntity variable = QTaskVariableEntity.taskVariableEntity;
        BooleanExpression expression = variable.taskId.eq((Object)td);
        if (predicate != null) {
            expression = expression.and(predicate);
        }
        BooleanExpression extendedPredicated = expression;
        Page variables = this.variableRepository.findAll((Predicate)extendedPredicated, pageable);
        return this.pagedCollectionModelAssembler.toModel(pageable, variables, (RepresentationModelAssembler)this.variableRepresentationModelAssembler);
    }
}

