/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest;

import com.fasterxml.jackson.annotation.JsonView;
import com.querydsl.core.types.Predicate;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.activiti.cloud.alfresco.data.domain.AlfrescoPagedModelAssembler;
import org.activiti.cloud.api.process.model.QueryCloudProcessInstance;
import org.activiti.cloud.services.query.model.JsonViews;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity;
import org.activiti.cloud.services.query.rest.ProcessInstanceAdminService;
import org.activiti.cloud.services.query.rest.assembler.ProcessInstanceRepresentationModelAssembler;
import org.activiti.cloud.services.query.rest.helper.ProcessInstanceAdminControllerHelper;
import org.activiti.cloud.services.query.rest.payload.ProcessInstanceQueryBody;
import org.activiti.cloud.services.query.rest.payload.ProcessInstanceSearchRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.querydsl.binding.QuerydslPredicate;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.http.converter.json.MappingJacksonValue;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/v1/process-instances"}, produces={"application/hal+json", "application/json"})
public class ProcessInstanceAdminController {
    private final ProcessInstanceAdminService processInstanceAdminService;
    private final ProcessInstanceRepresentationModelAssembler processInstanceRepresentationModelAssembler;
    private final AlfrescoPagedModelAssembler<ProcessInstanceEntity> pagedCollectionModelAssembler;
    private final ProcessInstanceAdminControllerHelper processInstanceAdminControllerHelper;

    @Autowired
    public ProcessInstanceAdminController(ProcessInstanceAdminService processInstanceAdminService, ProcessInstanceRepresentationModelAssembler processInstanceRepresentationModelAssembler, AlfrescoPagedModelAssembler<ProcessInstanceEntity> pagedCollectionModelAssembler, ProcessInstanceAdminControllerHelper processInstanceAdminControllerHelper) {
        this.processInstanceAdminService = processInstanceAdminService;
        this.processInstanceRepresentationModelAssembler = processInstanceRepresentationModelAssembler;
        this.pagedCollectionModelAssembler = pagedCollectionModelAssembler;
        this.processInstanceAdminControllerHelper = processInstanceAdminControllerHelper;
    }

    @Operation(summary="Find process instances", hidden=true)
    @JsonView(value={JsonViews.General.class})
    @RequestMapping(method={RequestMethod.GET}, params={"!variableKeys"})
    public PagedModel<EntityModel<QueryCloudProcessInstance>> findAllProcessInstanceAdmin(@Parameter(description="Predicate binding to core entity parameter values.", example="{\"name\": \"Real name\"}") @QuerydslPredicate(root=ProcessInstanceEntity.class) Predicate predicate, Pageable pageable) {
        return this.pagedCollectionModelAssembler.toModel(pageable, this.processInstanceAdminControllerHelper.findAllProcessInstanceAdmin(predicate, pageable), (RepresentationModelAssembler)this.processInstanceRepresentationModelAssembler);
    }

    @Operation(summary="Find process instances")
    @JsonView(value={JsonViews.ProcessVariables.class})
    @RequestMapping(method={RequestMethod.GET}, params={"variableKeys"})
    public PagedModel<EntityModel<QueryCloudProcessInstance>> findAllWithVariablesAdmin(@Parameter(description="Predicate binding to core entity parameter values.", example="{\"name\": \"Real name\"}") @QuerydslPredicate(root=ProcessInstanceEntity.class) Predicate predicate, @Parameter(description="Used to retrieve process variables. It is constructed from process definition key and variable name, e.g.: {processDefinitionKey}/{variableName}.", example="Process_90W_3nLpw/initializedVar") @RequestParam(value="variableKeys", required=false, defaultValue="") List<String> variableKeys, Pageable pageable) {
        return this.pagedCollectionModelAssembler.toModel(pageable, this.processInstanceAdminControllerHelper.findAllProcessInstanceAdminWithVariables(predicate, variableKeys, pageable), (RepresentationModelAssembler)this.processInstanceRepresentationModelAssembler);
    }

    @RequestMapping(method={RequestMethod.POST})
    public MappingJacksonValue findAllFromBodyProcessAdmin(@Parameter(description="Predicate binding to core entity parameter values.", example="{\"name\": \"Real name\"}") @QuerydslPredicate(root=ProcessInstanceEntity.class) Predicate predicate, @RequestBody(required=false) ProcessInstanceQueryBody payload, Pageable pageable) {
        ProcessInstanceQueryBody queryBody = Optional.ofNullable(payload).orElse(new ProcessInstanceQueryBody());
        PagedModel pagedModel = this.pagedCollectionModelAssembler.toModel(pageable, this.processInstanceAdminService.findAllFromBody(predicate, queryBody.getVariableKeys(), Collections.emptyList(), pageable), (RepresentationModelAssembler)this.processInstanceRepresentationModelAssembler);
        MappingJacksonValue result = new MappingJacksonValue((Object)pagedModel);
        if (queryBody.hasVariableKeys()) {
            result.setSerializationView(JsonViews.ProcessVariables.class);
        } else {
            result.setSerializationView(JsonViews.General.class);
        }
        return result;
    }

    @Operation(summary="Search process instances")
    @JsonView(value={JsonViews.ProcessVariables.class})
    @PostMapping(value={"/search"})
    public PagedModel<EntityModel<QueryCloudProcessInstance>> searchProcessInstances(@RequestBody ProcessInstanceSearchRequest searchRequest, Pageable pageable) {
        return this.pagedCollectionModelAssembler.toModel(pageable, this.processInstanceAdminControllerHelper.searchProcessInstances(searchRequest, pageable), (RepresentationModelAssembler)this.processInstanceRepresentationModelAssembler);
    }

    @JsonView(value={JsonViews.General.class})
    @RequestMapping(value={"/{processInstanceId}"}, method={RequestMethod.GET})
    public EntityModel<QueryCloudProcessInstance> findByIdProcessAdmin(@PathVariable String processInstanceId) {
        return this.processInstanceRepresentationModelAssembler.toModel(this.processInstanceAdminControllerHelper.findByIdProcessAdmin(processInstanceId));
    }

    @Operation(summary="Find application versions for process instances")
    @RequestMapping(value={"/appVersions"}, method={RequestMethod.GET})
    public Set<String> findProcessAppVersions(@Parameter(description="Predicate binding to core entity parameter values.", example="{\"name\": \"Real name\"}") @QuerydslPredicate(root=ProcessInstanceEntity.class) Predicate predicate) {
        return this.processInstanceAdminService.findAllAppVersions(predicate);
    }

    @Operation(summary="Count process instances")
    @JsonView(value={JsonViews.ProcessVariables.class})
    @PostMapping(value={"/count"})
    public Long searchProcessInstances(@RequestBody ProcessInstanceSearchRequest searchRequest) {
        return this.processInstanceAdminService.count(searchRequest);
    }

    @JsonView(value={JsonViews.General.class})
    @RequestMapping(value={"/{processInstanceId}/subprocesses"}, method={RequestMethod.GET})
    public PagedModel<EntityModel<QueryCloudProcessInstance>> subprocesses(@PathVariable String processInstanceId, @Parameter(description="Predicate binding to core entity parameter values.", example="{\"name\": \"Real name\"}") @QuerydslPredicate(root=ProcessInstanceEntity.class) Predicate predicate, Pageable pageable) {
        return this.pagedCollectionModelAssembler.toModel(pageable, this.processInstanceAdminControllerHelper.searchSubprocesses(processInstanceId, predicate, pageable), (RepresentationModelAssembler)this.processInstanceRepresentationModelAssembler);
    }
}

