/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest;

import org.activiti.cloud.services.query.app.repository.EntityFinder;
import org.activiti.cloud.services.query.app.repository.ProcessModelRepository;
import org.activiti.cloud.services.query.model.ProcessModelEntity;
import org.springframework.data.repository.CrudRepository;
import org.springframework.hateoas.server.ExposesResourceFor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ExposesResourceFor(value=ProcessModelEntity.class)
@RequestMapping(value={"/admin/v1/process-definitions/{processDefinitionId}/model"})
public class ProcessModelAdminController {
    private ProcessModelRepository processModelRepository;
    private EntityFinder entityFinder;

    public ProcessModelAdminController(ProcessModelRepository processModelRepository, EntityFinder entityFinder) {
        this.processModelRepository = processModelRepository;
        this.entityFinder = entityFinder;
    }

    @GetMapping(produces={"application/xml"})
    @ResponseBody
    public String getProcessModelAdmin(@PathVariable(value="processDefinitionId") String processDefinitionId) {
        return ((ProcessModelEntity)this.entityFinder.findById((CrudRepository)this.processModelRepository, (Object)processDefinitionId, "Unable to find process model for the given id:'" + processDefinitionId + "`")).getProcessModelContent();
    }
}

