/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest;

import org.activiti.api.runtime.model.impl.ProcessVariablesMapTypeRegistry;
import org.activiti.cloud.services.query.model.VariableValue;
import org.activiti.cloud.services.query.rest.VariableSearch;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class VariableSearchArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final String VARIABLE_NAME_KEY = "variables.name";
    private static final String VARIABLE_VALUE_KEY = "variables.value";
    private static final String VARIABLE_TYPE_KEY = "variables.type";
    private ConversionService conversionService;

    public VariableSearchArgumentResolver(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.getParameterType().equals(VariableSearch.class);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        String variableType = webRequest.getParameter(VARIABLE_TYPE_KEY);
        Class type = ProcessVariablesMapTypeRegistry.forType((String)variableType, String.class);
        Object variableValueParameter = webRequest.getParameter(VARIABLE_VALUE_KEY);
        if (!String.class.equals((Object)type)) {
            variableValueParameter = this.conversionService.convert(variableValueParameter, type);
        }
        String variableName = webRequest.getParameter(VARIABLE_NAME_KEY);
        return new VariableSearch(variableName, new VariableValue(variableValueParameter), variableType);
    }
}

