/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.rest.controllers;

import org.activiti.api.runtime.shared.query.Page;
import org.activiti.api.task.model.Task;
import org.activiti.api.task.model.builders.TaskPayloadBuilder;
import org.activiti.api.task.runtime.TaskRuntime;
import org.activiti.cloud.alfresco.data.domain.AlfrescoPagedModelAssembler;
import org.activiti.cloud.api.task.model.CloudTask;
import org.activiti.cloud.services.core.pageable.SpringPageConverter;
import org.activiti.cloud.services.rest.api.ProcessInstanceTasksController;
import org.activiti.cloud.services.rest.assemblers.TaskRepresentationModelAssembler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(produces={"application/hal+json", "application/json"})
public class ProcessInstanceTasksControllerImpl
implements ProcessInstanceTasksController {
    private final TaskRuntime taskRuntime;
    private final TaskRepresentationModelAssembler taskRepresentationModelAssembler;
    private final AlfrescoPagedModelAssembler<Task> pagedCollectionModelAssembler;
    private final SpringPageConverter pageConverter;

    @Autowired
    public ProcessInstanceTasksControllerImpl(TaskRuntime taskRuntime, TaskRepresentationModelAssembler taskRepresentationModelAssembler, AlfrescoPagedModelAssembler<Task> pagedCollectionModelAssembler, SpringPageConverter pageConverter) {
        this.taskRuntime = taskRuntime;
        this.taskRepresentationModelAssembler = taskRepresentationModelAssembler;
        this.pagedCollectionModelAssembler = pagedCollectionModelAssembler;
        this.pageConverter = pageConverter;
    }

    public PagedModel<EntityModel<CloudTask>> getTasks(@PathVariable String processInstanceId, Pageable pageable) {
        Page page = this.taskRuntime.tasks(this.pageConverter.toAPIPageable(pageable), TaskPayloadBuilder.tasks().withProcessInstanceId(processInstanceId).build());
        return this.pagedCollectionModelAssembler.toModel(pageable, this.pageConverter.toSpringPage(pageable, page), (RepresentationModelAssembler)this.taskRepresentationModelAssembler);
    }
}

