/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.api.process.model.payloads;

import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.activiti.api.model.shared.Payload;

public class MessageEventPayload
implements Payload {
    private String id = UUID.randomUUID().toString();
    private String name;
    private String correlationKey;
    private String businessKey;
    private Map<String, Object> variables;

    public MessageEventPayload() {
    }

    public MessageEventPayload(String name, String correlationKey, String businessKey, Map<String, Object> variables) {
        this();
        this.name = name;
        this.businessKey = businessKey;
        this.correlationKey = correlationKey;
        this.variables = variables;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public String getCorrelationKey() {
        return this.correlationKey;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MessageEventPayload [id=");
        builder.append(this.id);
        builder.append(", messageName=");
        builder.append(this.name);
        builder.append(", correlationKey=");
        builder.append(this.correlationKey);
        builder.append(", businessKey=");
        builder.append(this.businessKey);
        builder.append(", variables=");
        builder.append(this.variables);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return Objects.hash(this.businessKey, this.correlationKey, this.id, this.name, this.variables);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MessageEventPayload other = (MessageEventPayload)obj;
        return Objects.equals(this.businessKey, other.businessKey) && Objects.equals(this.correlationKey, other.correlationKey) && Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this.variables, other.variables);
    }
}

