/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.model.impl;

import java.util.List;
import java.util.Objects;
import org.activiti.api.process.model.ProcessInstance;
import org.activiti.api.runtime.model.impl.ProcessInstanceImpl;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.runtime.api.model.impl.APIIdentityLinkConverter;
import org.activiti.runtime.api.model.impl.ListConverter;
import org.activiti.runtime.api.model.impl.ModelConverter;

public class APIProcessInstanceConverter
extends ListConverter<org.activiti.engine.runtime.ProcessInstance, ProcessInstance>
implements ModelConverter<org.activiti.engine.runtime.ProcessInstance, ProcessInstance> {
    private final APIIdentityLinkConverter identityLinkConverter;

    public APIProcessInstanceConverter(APIIdentityLinkConverter identityLinkConverter) {
        this.identityLinkConverter = identityLinkConverter;
    }

    public ProcessInstance from(org.activiti.engine.runtime.ProcessInstance internalProcessInstance) {
        ProcessInstanceImpl processInstance = new ProcessInstanceImpl();
        processInstance.setId(internalProcessInstance.getId());
        processInstance.setParentId(internalProcessInstance.getParentProcessInstanceId());
        processInstance.setName(internalProcessInstance.getName());
        processInstance.setProcessDefinitionId(internalProcessInstance.getProcessDefinitionId());
        processInstance.setProcessDefinitionKey(internalProcessInstance.getProcessDefinitionKey());
        processInstance.setProcessDefinitionVersion(internalProcessInstance.getProcessDefinitionVersion());
        processInstance.setInitiator(internalProcessInstance.getStartUserId());
        processInstance.setStartDate(internalProcessInstance.getStartTime());
        processInstance.setProcessDefinitionKey(internalProcessInstance.getProcessDefinitionKey());
        processInstance.setBusinessKey(internalProcessInstance.getBusinessKey());
        processInstance.setStatus(this.calculateStatus(internalProcessInstance));
        processInstance.setProcessDefinitionVersion(internalProcessInstance.getProcessDefinitionVersion());
        processInstance.setAppVersion(Objects.toString(internalProcessInstance.getAppVersion(), null));
        processInstance.setProcessDefinitionName(internalProcessInstance.getProcessDefinitionName());
        processInstance.setRootProcessInstanceId(internalProcessInstance.getRootProcessInstanceId());
        return processInstance;
    }

    public ProcessInstance from(org.activiti.engine.runtime.ProcessInstance internalProcessInstance, List<IdentityLinkEntity> identityLinks) {
        ProcessInstanceImpl processInstance = (ProcessInstanceImpl)this.from(internalProcessInstance);
        if (identityLinks != null) {
            processInstance.setIdentityLinks(this.identityLinkConverter.from(identityLinks));
        }
        return processInstance;
    }

    private ProcessInstance.ProcessInstanceStatus calculateStatus(org.activiti.engine.runtime.ProcessInstance internalProcessInstance) {
        if (internalProcessInstance.isSuspended()) {
            return ProcessInstance.ProcessInstanceStatus.SUSPENDED;
        }
        if (internalProcessInstance.isEnded()) {
            return ProcessInstance.ProcessInstanceStatus.COMPLETED;
        }
        if (internalProcessInstance.getStartTime() == null) {
            return ProcessInstance.ProcessInstanceStatus.CREATED;
        }
        return ProcessInstance.ProcessInstanceStatus.RUNNING;
    }
}

