/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter.parser;

import java.util.List;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.constants.BpmnXMLConstants;
import org.activiti.bpmn.converter.child.ActivitiEventListenerParser;
import org.activiti.bpmn.converter.child.ExecutionListenerParser;
import org.activiti.bpmn.converter.parser.PotentialStarterParser;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SubProcess;

public class ExtensionElementsParser
implements BpmnXMLConstants {
    public void parse(XMLStreamReader xtr, List<SubProcess> activeSubProcessList, Process activeProcess, BpmnModel model) throws Exception {
        Object parentElement = null;
        parentElement = !activeSubProcessList.isEmpty() ? (BaseElement)activeSubProcessList.getLast() : activeProcess;
        boolean readyWithChildElements = false;
        while (!readyWithChildElements && xtr.hasNext()) {
            xtr.next();
            if (xtr.isStartElement()) {
                if ("executionListener".equals(xtr.getLocalName())) {
                    new ExecutionListenerParser().parseChildElement(xtr, (BaseElement)parentElement, model);
                    continue;
                }
                if ("eventListener".equals(xtr.getLocalName())) {
                    new ActivitiEventListenerParser().parseChildElement(xtr, (BaseElement)parentElement, model);
                    continue;
                }
                if ("potentialStarter".equals(xtr.getLocalName())) {
                    new PotentialStarterParser().parse(xtr, activeProcess);
                    continue;
                }
                ExtensionElement extensionElement = BpmnXMLUtil.parseExtensionElement(xtr);
                if (parentElement == null) continue;
                parentElement.addExtensionElement(extensionElement);
                continue;
            }
            if (!xtr.isEndElement() || !"extensionElements".equals(xtr.getLocalName())) continue;
            readyWithChildElements = true;
        }
    }
}

