/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import junit.framework.AssertionFailedError;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.DynamicBpmnService;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ManagementService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.ProcessEngineImpl;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.history.HistoryLevel;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandConfig;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.test.AbstractTestCase;
import org.activiti.engine.impl.test.JobTestHelper;
import org.activiti.engine.impl.test.TestHelper;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.assertj.core.api.AbstractDateAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;

public abstract class AbstractActivitiTestCase
extends AbstractTestCase {
    private static final List<String> TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK = Collections.singletonList("ACT_GE_PROPERTY");
    protected ProcessEngine processEngine;
    protected String deploymentIdFromDeploymentAnnotation;
    protected List<String> deploymentIdsForAutoCleanup = new ArrayList<String>();
    protected Throwable exception;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected HistoryService historyService;
    protected ManagementService managementService;
    protected DynamicBpmnService dynamicBpmnService;

    protected void setUp() throws Exception {
        super.setUp();
        Authentication.setAuthenticatedUserId(null);
    }

    protected abstract void initializeProcessEngine();

    protected void closeDownProcessEngine() {
    }

    public void runBare() throws Throwable {
        this.initializeProcessEngine();
        if (this.repositoryService == null) {
            this.initializeServices();
        }
        try {
            this.deploymentIdFromDeploymentAnnotation = TestHelper.annotationDeploymentSetUp(this.processEngine, ((Object)((Object)this)).getClass(), this.getName());
            super.runBare();
            this.validateHistoryData();
        }
        catch (AssertionFailedError e) {
            log.error("\n");
            log.error("ASSERTION FAILED: {}", (Object)e, (Object)e);
            this.exception = e;
            throw e;
        }
        catch (Throwable e) {
            log.error("\n");
            log.error("EXCEPTION: {}", (Object)e, (Object)e);
            this.exception = e;
            throw e;
        }
        finally {
            if (this.deploymentIdFromDeploymentAnnotation != null) {
                TestHelper.annotationDeploymentTearDown(this.processEngine, this.deploymentIdFromDeploymentAnnotation, ((Object)((Object)this)).getClass(), this.getName());
                this.deploymentIdFromDeploymentAnnotation = null;
            }
            for (String autoDeletedDeploymentId : this.deploymentIdsForAutoCleanup) {
                this.repositoryService.deleteDeployment(autoDeletedDeploymentId, true);
            }
            this.deploymentIdsForAutoCleanup.clear();
            this.assertAndEnsureCleanDb();
            this.processEngineConfiguration.getClock().reset();
            this.closeDownProcessEngine();
        }
    }

    protected void validateHistoryData() {
        if (this.processEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
            List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().finished().list();
            for (HistoricProcessInstance historicProcessInstance : historicProcessInstances) {
                List historicActivityInstances;
                ((AbstractStringAssert)Assertions.assertThat((String)historicProcessInstance.getProcessDefinitionId()).as("Historic process instance has no process definition id", new Object[0])).isNotNull();
                ((AbstractStringAssert)Assertions.assertThat((String)historicProcessInstance.getProcessDefinitionKey()).as("Historic process instance has no process definition key", new Object[0])).isNotNull();
                ((AbstractIntegerAssert)Assertions.assertThat((Integer)historicProcessInstance.getProcessDefinitionVersion()).as("Historic process instance has no process definition version", new Object[0])).isNotNull();
                ((AbstractStringAssert)Assertions.assertThat((String)historicProcessInstance.getDeploymentId()).as("Historic process instance has no process definition key", new Object[0])).isNotNull();
                ((AbstractStringAssert)Assertions.assertThat((String)historicProcessInstance.getStartActivityId()).as("Historic process instance has no start activiti id", new Object[0])).isNotNull();
                ((AbstractDateAssert)Assertions.assertThat((Date)historicProcessInstance.getStartTime()).as("Historic process instance has no start time", new Object[0])).isNotNull();
                ((AbstractDateAssert)Assertions.assertThat((Date)historicProcessInstance.getEndTime()).as("Historic process instance has no end time", new Object[0])).isNotNull();
                String processInstanceId = historicProcessInstance.getId();
                List historicTaskInstances = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).list();
                if (historicTaskInstances != null && historicTaskInstances.size() > 0) {
                    for (HistoricTaskInstance historicTaskInstance : historicTaskInstances) {
                        Assertions.assertThat((String)historicTaskInstance.getProcessInstanceId()).isEqualTo(processInstanceId);
                        if (historicTaskInstance.getClaimTime() != null) {
                            ((AbstractLongAssert)Assertions.assertThat((Long)historicTaskInstance.getWorkTimeInMillis()).as("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no work time", new Object[0])).isNotNull();
                        }
                        ((AbstractStringAssert)Assertions.assertThat((String)historicTaskInstance.getId()).as("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no id", new Object[0])).isNotNull();
                        ((AbstractStringAssert)Assertions.assertThat((String)historicTaskInstance.getProcessInstanceId()).as("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no process instance id", new Object[0])).isNotNull();
                        ((AbstractStringAssert)Assertions.assertThat((String)historicTaskInstance.getExecutionId()).as("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no execution id", new Object[0])).isNotNull();
                        ((AbstractStringAssert)Assertions.assertThat((String)historicTaskInstance.getProcessDefinitionId()).as("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no process definition id", new Object[0])).isNotNull();
                        ((AbstractStringAssert)Assertions.assertThat((String)historicTaskInstance.getTaskDefinitionKey()).as("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no task definition key", new Object[0])).isNotNull();
                        ((AbstractDateAssert)Assertions.assertThat((Date)historicTaskInstance.getCreateTime()).as("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no create time", new Object[0])).isNotNull();
                        ((AbstractDateAssert)Assertions.assertThat((Date)historicTaskInstance.getStartTime()).as("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no start time", new Object[0])).isNotNull();
                        ((AbstractDateAssert)Assertions.assertThat((Date)historicTaskInstance.getEndTime()).as("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no end time", new Object[0])).isNotNull();
                    }
                }
                if ((historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).list()) == null || historicActivityInstances.size() <= 0) continue;
                for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
                    Assertions.assertThat((String)historicActivityInstance.getProcessInstanceId()).isEqualTo(processInstanceId);
                    ((AbstractStringAssert)Assertions.assertThat((String)historicActivityInstance.getActivityId()).as("Historic activity instance " + historicActivityInstance.getActivityId() + " has no activity id", new Object[0])).isNotNull();
                    ((AbstractStringAssert)Assertions.assertThat((String)historicActivityInstance.getActivityType()).as("Historic activity instance " + historicActivityInstance.getActivityId() + " has no activity type", new Object[0])).isNotNull();
                    ((AbstractStringAssert)Assertions.assertThat((String)historicActivityInstance.getProcessDefinitionId()).as("Historic activity instance " + historicActivityInstance.getActivityId() + " has no process definition id", new Object[0])).isNotNull();
                    ((AbstractStringAssert)Assertions.assertThat((String)historicActivityInstance.getProcessInstanceId()).as("Historic activity instance " + historicActivityInstance.getActivityId() + " has no process instance id", new Object[0])).isNotNull();
                    ((AbstractStringAssert)Assertions.assertThat((String)historicActivityInstance.getExecutionId()).as("Historic activity instance " + historicActivityInstance.getActivityId() + " has no execution id", new Object[0])).isNotNull();
                    ((AbstractDateAssert)Assertions.assertThat((Date)historicActivityInstance.getStartTime()).as("Historic activity instance " + historicActivityInstance.getActivityId() + " has no start time", new Object[0])).isNotNull();
                    ((AbstractDateAssert)Assertions.assertThat((Date)historicActivityInstance.getEndTime()).as("Historic activity instance " + historicActivityInstance.getActivityId() + " has no end time", new Object[0])).isNotNull();
                }
            }
        }
    }

    protected void assertAndEnsureCleanDb() throws Throwable {
        log.debug("verifying that db is clean after test");
        Map<String, Long> tableCounts = this.managementService.getTableCount();
        StringBuilder outputMessage = new StringBuilder();
        for (String tableName : tableCounts.keySet()) {
            Long count;
            String tableNameWithoutPrefix = tableName.replace(this.processEngineConfiguration.getDatabaseTablePrefix(), "");
            if (TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK.contains(tableNameWithoutPrefix) || (count = tableCounts.get(tableName)) == 0L) continue;
            outputMessage.append("  ").append(tableName).append(": ").append(count).append(" record(s) ");
        }
        if (outputMessage.length() > 0) {
            outputMessage.insert(0, "DB NOT CLEAN: \n");
            log.error("\n");
            log.error(outputMessage.toString());
            log.info("dropping and recreating db");
            CommandExecutor commandExecutor = ((ProcessEngineImpl)this.processEngine).getProcessEngineConfiguration().getCommandExecutor();
            CommandConfig config = new CommandConfig().transactionNotSupported();
            commandExecutor.execute(config, new Command<Object>(){

                @Override
                public Object execute(CommandContext commandContext) {
                    DbSqlSession session = commandContext.getDbSqlSession();
                    session.dbSchemaDrop();
                    session.dbSchemaCreate();
                    return null;
                }
            });
            if (this.exception != null) {
                throw this.exception;
            }
            AbstractActivitiTestCase.fail((String)outputMessage.toString());
        } else {
            log.info("database was clean");
        }
    }

    protected void initializeServices() {
        this.processEngineConfiguration = ((ProcessEngineImpl)this.processEngine).getProcessEngineConfiguration();
        this.repositoryService = this.processEngine.getRepositoryService();
        this.runtimeService = this.processEngine.getRuntimeService();
        this.taskService = this.processEngine.getTaskService();
        this.historyService = this.processEngine.getHistoryService();
        this.managementService = this.processEngine.getManagementService();
        this.dynamicBpmnService = this.processEngine.getDynamicBpmnService();
    }

    public void assertProcessEnded(String processInstanceId) {
        ProcessInstance processInstance = (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance != null) {
            throw new AssertionFailedError("Expected finished process instance '" + processInstanceId + "' but it was still in the db");
        }
        if (this.processEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
            List historicActivityInstances;
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            Assertions.assertThat((String)historicProcessInstance.getId()).isEqualTo(processInstanceId);
            ((AbstractDateAssert)Assertions.assertThat((Date)historicProcessInstance.getStartTime()).as("Historic process instance has no start time", new Object[0])).isNotNull();
            ((AbstractDateAssert)Assertions.assertThat((Date)historicProcessInstance.getEndTime()).as("Historic process instance has no end time", new Object[0])).isNotNull();
            List historicTaskInstances = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).list();
            if (historicTaskInstances != null && historicTaskInstances.size() > 0) {
                for (HistoricTaskInstance historicTaskInstance : historicTaskInstances) {
                    Assertions.assertThat((String)historicTaskInstance.getProcessInstanceId()).isEqualTo(processInstanceId);
                    ((AbstractDateAssert)Assertions.assertThat((Date)historicTaskInstance.getStartTime()).as("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no start time", new Object[0])).isNotNull();
                    ((AbstractDateAssert)Assertions.assertThat((Date)historicTaskInstance.getEndTime()).as("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no end time", new Object[0])).isNotNull();
                }
            }
            if ((historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).list()) != null && historicActivityInstances.size() > 0) {
                for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
                    Assertions.assertThat((String)historicActivityInstance.getProcessInstanceId()).isEqualTo(processInstanceId);
                    ((AbstractDateAssert)Assertions.assertThat((Date)historicActivityInstance.getStartTime()).as("Historic activity instance " + historicActivityInstance.getActivityId() + " has no start time", new Object[0])).isNotNull();
                    ((AbstractDateAssert)Assertions.assertThat((Date)historicActivityInstance.getEndTime()).as("Historic activity instance " + historicActivityInstance.getActivityId() + " has no end time", new Object[0])).isNotNull();
                }
            }
        }
    }

    public void waitForJobExecutorToProcessAllJobs(long maxMillisToWait, long intervalMillis) {
        JobTestHelper.waitForJobExecutorToProcessAllJobs(this.processEngineConfiguration, this.managementService, maxMillisToWait, intervalMillis);
    }

    public void waitForJobExecutorOnCondition(long maxMillisToWait, long intervalMillis, Callable<Boolean> condition) {
        JobTestHelper.waitForJobExecutorOnCondition(this.processEngineConfiguration, maxMillisToWait, intervalMillis, condition);
    }

    public void executeJobExecutorForTime(long maxMillisToWait, long intervalMillis) {
        JobTestHelper.executeJobExecutorForTime(this.processEngineConfiguration, maxMillisToWait, intervalMillis);
    }

    public void waitForJobExecutorToProcessAllJobsAndExecutableTimerJobs(long maxMillisToWait, long intervalMillis) {
        JobTestHelper.waitForJobExecutorToProcessAllJobsAndExecutableTimerJobs(this.processEngineConfiguration, this.managementService, maxMillisToWait, intervalMillis);
    }

    public BpmnModel createOneTaskTestProcess() {
        BpmnModel model = new BpmnModel();
        Process process = new Process();
        model.addProcess(process);
        process.setId("oneTaskProcess");
        process.setName("The one task process");
        StartEvent startEvent = new StartEvent();
        startEvent.setId("start");
        process.addFlowElement((FlowElement)startEvent);
        UserTask userTask = new UserTask();
        userTask.setName("The Task");
        userTask.setId("theTask");
        userTask.setAssignee("kermit");
        process.addFlowElement((FlowElement)userTask);
        EndEvent endEvent = new EndEvent();
        endEvent.setId("theEnd");
        process.addFlowElement((FlowElement)endEvent);
        process.addFlowElement((FlowElement)new SequenceFlow("start", "theTask"));
        process.addFlowElement((FlowElement)new SequenceFlow("theTask", "theEnd"));
        return model;
    }

    public BpmnModel createTwoTasksTestProcess() {
        BpmnModel model = new BpmnModel();
        Process process = new Process();
        model.addProcess(process);
        process.setId("twoTasksProcess");
        process.setName("The two tasks process");
        StartEvent startEvent = new StartEvent();
        startEvent.setId("start");
        process.addFlowElement((FlowElement)startEvent);
        UserTask userTask = new UserTask();
        userTask.setName("The First Task");
        userTask.setId("task1");
        userTask.setAssignee("kermit");
        process.addFlowElement((FlowElement)userTask);
        UserTask userTask2 = new UserTask();
        userTask2.setName("The Second Task");
        userTask2.setId("task2");
        userTask2.setAssignee("kermit");
        process.addFlowElement((FlowElement)userTask2);
        EndEvent endEvent = new EndEvent();
        endEvent.setId("theEnd");
        process.addFlowElement((FlowElement)endEvent);
        process.addFlowElement((FlowElement)new SequenceFlow("start", "task1"));
        process.addFlowElement((FlowElement)new SequenceFlow("start", "task2"));
        process.addFlowElement((FlowElement)new SequenceFlow("task1", "theEnd"));
        process.addFlowElement((FlowElement)new SequenceFlow("task2", "theEnd"));
        return model;
    }

    public BpmnModel createOneTaskAndStartEventWithFormKeyProcess() {
        BpmnModel model = new BpmnModel();
        Process process = new Process();
        model.addProcess(process);
        process.setId("testProcess");
        process.setName("Test process");
        StartEvent startEvent = new StartEvent();
        startEvent.setId("start");
        startEvent.setFormKey("testFormKey");
        process.addFlowElement((FlowElement)startEvent);
        UserTask userTask = new UserTask();
        userTask.setName("The Task");
        userTask.setId("theTask");
        userTask.setAssignee("kermit");
        process.addFlowElement((FlowElement)userTask);
        EndEvent endEvent = new EndEvent();
        endEvent.setId("theEnd");
        process.addFlowElement((FlowElement)endEvent);
        process.addFlowElement((FlowElement)new SequenceFlow("start", "theTask"));
        process.addFlowElement((FlowElement)new SequenceFlow("theTask", "theEnd"));
        return model;
    }

    public String deployOneTaskTestProcess() {
        BpmnModel bpmnModel = this.createOneTaskTestProcess();
        Deployment deployment = this.repositoryService.createDeployment().addBpmnModel("oneTasktest.bpmn20.xml", bpmnModel).deploy();
        this.deploymentIdsForAutoCleanup.add(deployment.getId());
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        return processDefinition.getId();
    }

    public String deployTwoTasksTestProcess() {
        BpmnModel bpmnModel = this.createTwoTasksTestProcess();
        Deployment deployment = this.repositoryService.createDeployment().addBpmnModel("twoTasksTestProcess.bpmn20.xml", bpmnModel).deploy();
        this.deploymentIdsForAutoCleanup.add(deployment.getId());
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        return processDefinition.getId();
    }

    protected void assertHistoricTasksDeleteReason(ProcessInstance processInstance, String expectedDeleteReason, String ... taskNames) {
        if (this.processEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
            for (String taskName : taskNames) {
                List historicTaskInstances = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstance.getId())).taskName(taskName)).list();
                Assertions.assertThat((historicTaskInstances.size() > 0 ? 1 : 0) != 0).isTrue();
                for (HistoricTaskInstance historicTaskInstance : historicTaskInstances) {
                    Assertions.assertThat((Date)historicTaskInstance.getEndTime()).isNotNull();
                    if (expectedDeleteReason == null) {
                        Assertions.assertThat((String)historicTaskInstance.getDeleteReason()).isNull();
                        continue;
                    }
                    Assertions.assertThat((boolean)historicTaskInstance.getDeleteReason().startsWith(expectedDeleteReason)).isTrue();
                }
            }
        }
    }

    protected void assertHistoricActivitiesDeleteReason(ProcessInstance processInstance, String expectedDeleteReason, String ... activityIds) {
        if (this.processEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
            for (String activityId : activityIds) {
                List historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().activityId(activityId).processInstanceId(processInstance.getId()).list();
                ((ListAssert)Assertions.assertThat(historicActivityInstances).as("Could not find historic activities", new Object[0])).isNotEmpty();
                for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
                    Assertions.assertThat((Date)historicActivityInstance.getEndTime()).isNotNull();
                    if (expectedDeleteReason == null) {
                        Assertions.assertThat((String)historicActivityInstance.getDeleteReason()).isNull();
                        continue;
                    }
                    Assertions.assertThat((boolean)historicActivityInstance.getDeleteReason().startsWith(expectedDeleteReason)).isTrue();
                }
            }
        }
    }
}

