/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.Collection;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.bpmn.behavior.GatewayActivityBehavior;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelGatewayActivityBehavior
extends GatewayActivityBehavior {
    private static final long serialVersionUID = 1840892471343975524L;
    private static Logger log = LoggerFactory.getLogger(ParallelGatewayActivityBehavior.class);

    @Override
    public void execute(DelegateExecution execution) {
        execution.inactivate();
        FlowElement flowElement = execution.getCurrentFlowElement();
        ParallelGateway parallelGateway = null;
        if (!(flowElement instanceof ParallelGateway)) {
            throw new ActivitiException("Programmatic error: parallel gateway behaviour can only be applied to a ParallelGateway instance, but got an instance of " + String.valueOf(flowElement));
        }
        parallelGateway = (ParallelGateway)flowElement;
        this.lockFirstParentScope(execution);
        DelegateExecution multiInstanceExecution = null;
        if (this.hasMultiInstanceParent((FlowNode)parallelGateway)) {
            multiInstanceExecution = this.findMultiInstanceParentExecution(execution);
        }
        ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
        Collection<ExecutionEntity> joinedExecutions = executionEntityManager.findInactiveExecutionsByActivityIdAndProcessInstanceId(execution.getCurrentActivityId(), execution.getProcessInstanceId());
        if (multiInstanceExecution != null) {
            joinedExecutions = this.cleanJoinedExecutions(joinedExecutions, multiInstanceExecution);
        }
        int nbrOfExecutionsToJoin = parallelGateway.getIncomingFlows().size();
        int nbrOfExecutionsCurrentlyJoined = joinedExecutions.size();
        Context.getCommandContext().getHistoryManager().recordActivityEnd((ExecutionEntity)execution, null);
        if (nbrOfExecutionsCurrentlyJoined == nbrOfExecutionsToJoin) {
            if (log.isDebugEnabled()) {
                log.debug("parallel gateway '{}' activates: {} of {} joined", new Object[]{execution.getCurrentActivityId(), nbrOfExecutionsCurrentlyJoined, nbrOfExecutionsToJoin});
            }
            if (parallelGateway.getIncomingFlows().size() > 1) {
                for (ExecutionEntity joinedExecution : joinedExecutions) {
                    if (joinedExecution.getId().equals(execution.getId())) continue;
                    executionEntityManager.deleteExecutionAndRelatedData(joinedExecution, null);
                }
            }
            Context.getAgenda().planTakeOutgoingSequenceFlowsOperation((ExecutionEntity)execution, false);
        } else if (log.isDebugEnabled()) {
            log.debug("parallel gateway '{}' does not activate: {} of {} joined", new Object[]{execution.getCurrentActivityId(), nbrOfExecutionsCurrentlyJoined, nbrOfExecutionsToJoin});
        }
    }

    protected Collection<ExecutionEntity> cleanJoinedExecutions(Collection<ExecutionEntity> joinedExecutions, DelegateExecution multiInstanceExecution) {
        ArrayList<ExecutionEntity> cleanedExecutions = new ArrayList<ExecutionEntity>();
        for (ExecutionEntity executionEntity : joinedExecutions) {
            if (!this.isChildOfMultiInstanceExecution(executionEntity, multiInstanceExecution)) continue;
            cleanedExecutions.add(executionEntity);
        }
        return cleanedExecutions;
    }

    protected boolean isChildOfMultiInstanceExecution(DelegateExecution executionEntity, DelegateExecution multiInstanceExecution) {
        boolean isChild = false;
        DelegateExecution parentExecution = executionEntity.getParent();
        if (parentExecution != null) {
            if (parentExecution.getId().equals(multiInstanceExecution.getId())) {
                isChild = true;
            } else {
                boolean isNestedChild = this.isChildOfMultiInstanceExecution(parentExecution, multiInstanceExecution);
                if (isNestedChild) {
                    isChild = true;
                }
            }
        }
        return isChild;
    }

    protected boolean hasMultiInstanceParent(FlowNode flowNode) {
        boolean hasMultiInstanceParent = false;
        if (flowNode.getSubProcess() != null) {
            if (flowNode.getSubProcess().getLoopCharacteristics() != null) {
                hasMultiInstanceParent = true;
            } else {
                boolean hasNestedMultiInstanceParent = this.hasMultiInstanceParent((FlowNode)flowNode.getSubProcess());
                if (hasNestedMultiInstanceParent) {
                    hasMultiInstanceParent = true;
                }
            }
        }
        return hasMultiInstanceParent;
    }

    protected DelegateExecution findMultiInstanceParentExecution(DelegateExecution execution) {
        DelegateExecution multiInstanceExecution = null;
        DelegateExecution parentExecution = execution.getParent();
        if (parentExecution != null && parentExecution.getCurrentFlowElement() != null) {
            DelegateExecution potentialMultiInstanceExecution;
            Activity activity;
            FlowElement flowElement = parentExecution.getCurrentFlowElement();
            if (flowElement instanceof Activity && (activity = (Activity)flowElement).getLoopCharacteristics() != null) {
                multiInstanceExecution = parentExecution;
            }
            if (multiInstanceExecution == null && (potentialMultiInstanceExecution = this.findMultiInstanceParentExecution(parentExecution)) != null) {
                multiInstanceExecution = potentialMultiInstanceExecution;
            }
        }
        return multiInstanceExecution;
    }
}

