/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.db;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.cfg.IdGenerator;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.db.EntityDependencyOrder;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.Session;
import org.activiti.engine.impl.interceptor.SessionFactory;
import org.activiti.engine.impl.persistence.entity.Entity;
import org.activiti.engine.impl.persistence.entity.EventLogEntryEntityImpl;
import org.apache.ibatis.session.SqlSessionFactory;

public class DbSqlSessionFactory
implements SessionFactory {
    protected static final Map<String, Map<String, String>> databaseSpecificStatements = new HashMap<String, Map<String, String>>();
    protected static Map<Class<? extends Entity>, Boolean> bulkInsertableMap;
    protected String databaseType;
    protected String databaseTablePrefix = "";
    private boolean tablePrefixIsSchema;
    protected String databaseCatalog;
    protected String databaseSchema;
    protected SqlSessionFactory sqlSessionFactory;
    protected IdGenerator idGenerator;
    protected Map<String, String> statementMappings;
    protected Map<Class<?>, String> insertStatements = new ConcurrentHashMap();
    protected Map<Class<?>, String> bulkInsertStatements = new ConcurrentHashMap();
    protected Map<Class<?>, String> updateStatements = new ConcurrentHashMap();
    protected Map<Class<?>, String> deleteStatements = new ConcurrentHashMap();
    protected Map<Class<?>, String> bulkDeleteStatements = new ConcurrentHashMap();
    protected Map<Class<?>, String> selectStatements = new ConcurrentHashMap();
    protected boolean isDbHistoryUsed = true;
    protected int maxNrOfStatementsInBulkInsert = 100;

    @Override
    public Class<?> getSessionType() {
        return DbSqlSession.class;
    }

    @Override
    public Session openSession(CommandContext commandContext) {
        DbSqlSession dbSqlSession = new DbSqlSession(this, commandContext.getEntityCache());
        if (this.getDatabaseSchema() != null && this.getDatabaseSchema().length() > 0) {
            try {
                dbSqlSession.getSqlSession().getConnection().setSchema(this.getDatabaseSchema());
            }
            catch (SQLException e) {
                throw new ActivitiException("Could not set database schema on connection", e);
            }
        }
        if (this.getDatabaseCatalog() != null && this.getDatabaseCatalog().length() > 0) {
            try {
                dbSqlSession.getSqlSession().getConnection().setCatalog(this.getDatabaseCatalog());
            }
            catch (SQLException e) {
                throw new ActivitiException("Could not set database catalog on connection", e);
            }
        }
        return dbSqlSession;
    }

    public String getInsertStatement(Entity object) {
        return this.getStatement(object.getClass(), this.insertStatements, "insert");
    }

    public String getInsertStatement(Class<? extends Entity> clazz) {
        return this.getStatement(clazz, this.insertStatements, "insert");
    }

    public String getBulkInsertStatement(Class clazz) {
        return this.getStatement(clazz, this.bulkInsertStatements, "bulkInsert");
    }

    public String getUpdateStatement(Entity object) {
        return this.getStatement(object.getClass(), this.updateStatements, "update");
    }

    public String getDeleteStatement(Class<?> entityClass) {
        return this.getStatement(entityClass, this.deleteStatements, "delete");
    }

    public String getBulkDeleteStatement(Class<?> entityClass) {
        return this.getStatement(entityClass, this.bulkDeleteStatements, "bulkDelete");
    }

    public String getSelectStatement(Class<?> entityClass) {
        return this.getStatement(entityClass, this.selectStatements, "select");
    }

    private String getStatement(Class<?> entityClass, Map<Class<?>, String> cachedStatements, String prefix) {
        Object statement = cachedStatements.get(entityClass);
        if (statement != null) {
            return statement;
        }
        statement = prefix + entityClass.getSimpleName();
        statement = ((String)statement).endsWith("Impl") ? ((String)statement).substring(0, ((String)statement).length() - 10) : ((String)statement).substring(0, ((String)statement).length() - 6);
        cachedStatements.put(entityClass, (String)statement);
        return statement;
    }

    protected static void addDatabaseSpecificStatement(String databaseType, String activitiStatement, String ibatisStatement) {
        Map<String, String> specificStatements = databaseSpecificStatements.get(databaseType);
        if (specificStatements == null) {
            specificStatements = new HashMap<String, String>();
            databaseSpecificStatements.put(databaseType, specificStatements);
        }
        specificStatements.put(activitiStatement, ibatisStatement);
    }

    public String mapStatement(String statement) {
        if (this.statementMappings == null) {
            return statement;
        }
        String mappedStatement = this.statementMappings.get(statement);
        return mappedStatement != null ? mappedStatement : statement;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
        this.statementMappings = databaseSpecificStatements.get(databaseType);
    }

    public void setBulkInsertEnabled(boolean isBulkInsertEnabled, String databaseType) {
        if (isBulkInsertEnabled) {
            this.initBulkInsertEnabledMap(databaseType);
        }
    }

    protected void initBulkInsertEnabledMap(String databaseType) {
        bulkInsertableMap = new HashMap<Class<? extends Entity>, Boolean>();
        for (Class<? extends Entity> clazz : EntityDependencyOrder.INSERT_ORDER) {
            bulkInsertableMap.put(clazz, Boolean.TRUE);
        }
        if ("oracle".equals(databaseType)) {
            bulkInsertableMap.put(EventLogEntryEntityImpl.class, Boolean.FALSE);
        }
    }

    public Boolean isBulkInsertable(Class<? extends Entity> entityClass) {
        return bulkInsertableMap != null && bulkInsertableMap.containsKey(entityClass) && bulkInsertableMap.get(entityClass) != false;
    }

    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }

    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public Map<String, String> getStatementMappings() {
        return this.statementMappings;
    }

    public void setStatementMappings(Map<String, String> statementMappings) {
        this.statementMappings = statementMappings;
    }

    public Map<Class<?>, String> getInsertStatements() {
        return this.insertStatements;
    }

    public void setInsertStatements(Map<Class<?>, String> insertStatements) {
        this.insertStatements = insertStatements;
    }

    public Map<Class<?>, String> getBulkInsertStatements() {
        return this.bulkInsertStatements;
    }

    public void setBulkInsertStatements(Map<Class<?>, String> bulkInsertStatements) {
        this.bulkInsertStatements = bulkInsertStatements;
    }

    public Map<Class<?>, String> getUpdateStatements() {
        return this.updateStatements;
    }

    public void setUpdateStatements(Map<Class<?>, String> updateStatements) {
        this.updateStatements = updateStatements;
    }

    public Map<Class<?>, String> getDeleteStatements() {
        return this.deleteStatements;
    }

    public void setDeleteStatements(Map<Class<?>, String> deleteStatements) {
        this.deleteStatements = deleteStatements;
    }

    public Map<Class<?>, String> getBulkDeleteStatements() {
        return this.bulkDeleteStatements;
    }

    public void setBulkDeleteStatements(Map<Class<?>, String> bulkDeleteStatements) {
        this.bulkDeleteStatements = bulkDeleteStatements;
    }

    public Map<Class<?>, String> getSelectStatements() {
        return this.selectStatements;
    }

    public void setSelectStatements(Map<Class<?>, String> selectStatements) {
        this.selectStatements = selectStatements;
    }

    public boolean isDbHistoryUsed() {
        return this.isDbHistoryUsed;
    }

    public void setDbHistoryUsed(boolean isDbHistoryUsed) {
        this.isDbHistoryUsed = isDbHistoryUsed;
    }

    public void setDatabaseTablePrefix(String databaseTablePrefix) {
        this.databaseTablePrefix = databaseTablePrefix;
    }

    public String getDatabaseTablePrefix() {
        return this.databaseTablePrefix;
    }

    public String getDatabaseCatalog() {
        return this.databaseCatalog;
    }

    public void setDatabaseCatalog(String databaseCatalog) {
        this.databaseCatalog = databaseCatalog;
    }

    public String getDatabaseSchema() {
        return this.databaseSchema;
    }

    public void setDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
    }

    public void setTablePrefixIsSchema(boolean tablePrefixIsSchema) {
        this.tablePrefixIsSchema = tablePrefixIsSchema;
    }

    public boolean isTablePrefixIsSchema() {
        return this.tablePrefixIsSchema;
    }

    public int getMaxNrOfStatementsInBulkInsert() {
        return this.maxNrOfStatementsInBulkInsert;
    }

    public void setMaxNrOfStatementsInBulkInsert(int maxNrOfStatementsInBulkInsert) {
        this.maxNrOfStatementsInBulkInsert = maxNrOfStatementsInBulkInsert;
    }
}

