/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.scripting;

import jakarta.el.ArrayELResolver;
import jakarta.el.BeanELResolver;
import jakarta.el.CompositeELResolver;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ELResolver;
import jakarta.el.ExpressionFactory;
import jakarta.el.FunctionMapper;
import jakarta.el.ListELResolver;
import jakarta.el.MapELResolver;
import jakarta.el.ResourceBundleELResolver;
import jakarta.el.ValueExpression;
import jakarta.el.VariableMapper;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.activiti.core.el.ELResolverReflectionBlockerDecorator;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.bpmn.data.ItemInstance;
import org.activiti.engine.impl.el.CustomMapperJsonNodeELResolver;
import org.activiti.engine.impl.el.DynamicBeanPropertyELResolver;
import org.activiti.engine.impl.scripting.JuelScriptEngineFactory;
import org.activiti.engine.impl.util.ReflectUtil;

public class JuelScriptEngine
extends AbstractScriptEngine
implements Compilable {
    private ScriptEngineFactory scriptEngineFactory;
    private ExpressionFactory expressionFactory;

    public JuelScriptEngine(ScriptEngineFactory scriptEngineFactory) {
        this.scriptEngineFactory = scriptEngineFactory;
        this.expressionFactory = ExpressionFactory.newInstance();
    }

    public JuelScriptEngine() {
        this((ScriptEngineFactory)null);
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        ValueExpression expr = this.parse(script, this.context);
        return new JuelCompiledScript(expr);
    }

    @Override
    public CompiledScript compile(Reader reader) throws ScriptException {
        return this.compile(this.readFully(reader));
    }

    @Override
    public Object eval(String script, ScriptContext scriptContext) throws ScriptException {
        ValueExpression expr = this.parse(script, scriptContext);
        return this.evaluateExpression(expr, scriptContext);
    }

    @Override
    public Object eval(Reader reader, ScriptContext scriptContext) throws ScriptException {
        return this.eval(this.readFully(reader), scriptContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScriptEngineFactory getFactory() {
        JuelScriptEngine juelScriptEngine = this;
        synchronized (juelScriptEngine) {
            if (this.scriptEngineFactory == null) {
                this.scriptEngineFactory = new JuelScriptEngineFactory();
            }
        }
        return this.scriptEngineFactory;
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    private Object evaluateExpression(ValueExpression expr, ScriptContext ctx) throws ScriptException {
        try {
            return expr.getValue(this.createElContext(ctx));
        }
        catch (ELException elexp) {
            throw new ScriptException((Exception)((Object)elexp));
        }
    }

    private ELResolver createElResolver() {
        CompositeELResolver compositeResolver = new CompositeELResolver();
        compositeResolver.add((ELResolver)new ArrayELResolver());
        compositeResolver.add((ELResolver)new ListELResolver());
        compositeResolver.add((ELResolver)new MapELResolver());
        compositeResolver.add((ELResolver)new CustomMapperJsonNodeELResolver());
        compositeResolver.add((ELResolver)new ResourceBundleELResolver());
        compositeResolver.add((ELResolver)new DynamicBeanPropertyELResolver(ItemInstance.class, "getFieldValue", "setFieldValue"));
        compositeResolver.add((ELResolver)new ELResolverReflectionBlockerDecorator((ELResolver)new BeanELResolver()));
        return compositeResolver;
    }

    private String readFully(Reader reader) throws ScriptException {
        char[] array = new char[8192];
        StringBuilder strBuffer = new StringBuilder();
        try {
            int count;
            while ((count = reader.read(array, 0, array.length)) > 0) {
                strBuffer.append(array, 0, count);
            }
        }
        catch (IOException exp) {
            throw new ScriptException(exp);
        }
        return strBuffer.toString();
    }

    private ValueExpression parse(String script, ScriptContext scriptContext) throws ScriptException {
        try {
            return this.expressionFactory.createValueExpression(this.createElContext(scriptContext), script, Object.class);
        }
        catch (ELException ele) {
            throw new ScriptException((Exception)((Object)ele));
        }
    }

    private ELContext createElContext(final ScriptContext scriptCtx) {
        Object existingELCtx = scriptCtx.getAttribute("elcontext");
        if (existingELCtx instanceof ELContext) {
            return (ELContext)existingELCtx;
        }
        scriptCtx.setAttribute("context", scriptCtx, 100);
        scriptCtx.setAttribute("out:print", JuelScriptEngine.getPrintMethod(), 100);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            scriptCtx.setAttribute("lang:import", JuelScriptEngine.getImportMethod(), 100);
        }
        ELContext elContext = new ELContext(){
            ELResolver resolver;
            VariableMapper varMapper;
            FunctionMapper funcMapper;
            {
                this.resolver = JuelScriptEngine.this.createElResolver();
                this.varMapper = new ScriptContextVariableMapper(scriptCtx);
                this.funcMapper = new ScriptContextFunctionMapper(JuelScriptEngine.this, scriptCtx);
            }

            public ELResolver getELResolver() {
                return this.resolver;
            }

            public VariableMapper getVariableMapper() {
                return this.varMapper;
            }

            public FunctionMapper getFunctionMapper() {
                return this.funcMapper;
            }
        };
        scriptCtx.setAttribute("elcontext", elContext, 100);
        return elContext;
    }

    private static Method getPrintMethod() {
        try {
            return JuelScriptEngine.class.getMethod("print", Object.class);
        }
        catch (Exception exp) {
            return null;
        }
    }

    public static void print(Object object) {
        System.out.print(object);
    }

    private static Method getImportMethod() {
        try {
            return JuelScriptEngine.class.getMethod("importFunctions", ScriptContext.class, String.class, Object.class);
        }
        catch (Exception exp) {
            return null;
        }
    }

    public static void importFunctions(ScriptContext ctx, String namespace, Object obj) {
        Method[] methods;
        Class<?> clazz = null;
        if (obj instanceof Class) {
            clazz = (Class<?>)obj;
        } else if (obj instanceof String) {
            try {
                clazz = ReflectUtil.loadClass((String)obj);
            }
            catch (ActivitiException ae) {
                throw new ELException((Throwable)ae);
            }
        } else {
            throw new ELException("Class or class name is missing");
        }
        for (Method m : methods = clazz.getMethods()) {
            int mod = m.getModifiers();
            if (!Modifier.isStatic(mod) || !Modifier.isPublic(mod)) continue;
            String name = namespace + ":" + m.getName();
            ctx.setAttribute(name, m, 100);
        }
    }

    private class JuelCompiledScript
    extends CompiledScript {
        private ValueExpression valueExpression;

        JuelCompiledScript(ValueExpression valueExpression) {
            this.valueExpression = valueExpression;
        }

        @Override
        public ScriptEngine getEngine() {
            return JuelScriptEngine.this;
        }

        @Override
        public Object eval(ScriptContext ctx) throws ScriptException {
            return JuelScriptEngine.this.evaluateExpression(this.valueExpression, ctx);
        }
    }

    private class ScriptContextFunctionMapper
    extends FunctionMapper {
        private ScriptContext scriptContext;

        ScriptContextFunctionMapper(JuelScriptEngine juelScriptEngine, ScriptContext ctx) {
            this.scriptContext = ctx;
        }

        private String getFullFunctionName(String prefix, String localName) {
            return prefix + ":" + localName;
        }

        public Method resolveFunction(String prefix, String localName) {
            String functionName = this.getFullFunctionName(prefix, localName);
            int scope = this.scriptContext.getAttributesScope(functionName);
            if (scope != -1) {
                Object attributeValue = this.scriptContext.getAttribute(functionName);
                return attributeValue instanceof Method ? (Method)attributeValue : null;
            }
            return null;
        }
    }

    private class ScriptContextVariableMapper
    extends VariableMapper {
        private ScriptContext scriptContext;

        ScriptContextVariableMapper(ScriptContext scriptCtx) {
            this.scriptContext = scriptCtx;
        }

        public ValueExpression resolveVariable(String variableName) {
            int scope = this.scriptContext.getAttributesScope(variableName);
            if (scope != -1) {
                Object value = this.scriptContext.getAttribute(variableName, scope);
                if (value instanceof ValueExpression) {
                    return (ValueExpression)value;
                }
                return JuelScriptEngine.this.expressionFactory.createValueExpression(value, Object.class);
            }
            return null;
        }

        public ValueExpression setVariable(String name, ValueExpression value) {
            ValueExpression previousValue = this.resolveVariable(name);
            this.scriptContext.setAttribute(name, value, 100);
            return previousValue;
        }
    }
}

