/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.Assignment;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.DataAssociation;
import org.activiti.bpmn.model.DataSpec;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.IOSpecification;
import org.activiti.bpmn.model.Import;
import org.activiti.bpmn.model.Interface;
import org.activiti.bpmn.model.ItemDefinition;
import org.activiti.bpmn.model.Message;
import org.activiti.bpmn.model.Operation;
import org.activiti.bpmn.model.SendTask;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.BpmnError;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.bpmn.data.AbstractDataAssociation;
import org.activiti.engine.impl.bpmn.data.ClassStructureDefinition;
import org.activiti.engine.impl.bpmn.data.ItemInstance;
import org.activiti.engine.impl.bpmn.data.ItemKind;
import org.activiti.engine.impl.bpmn.data.SimpleDataInputAssociation;
import org.activiti.engine.impl.bpmn.data.StructureDefinition;
import org.activiti.engine.impl.bpmn.data.TransformationDataOutputAssociation;
import org.activiti.engine.impl.bpmn.helper.ErrorPropagation;
import org.activiti.engine.impl.bpmn.parser.XMLImporter;
import org.activiti.engine.impl.bpmn.webservice.BpmnInterface;
import org.activiti.engine.impl.bpmn.webservice.MessageDefinition;
import org.activiti.engine.impl.bpmn.webservice.MessageImplicitDataInputAssociation;
import org.activiti.engine.impl.bpmn.webservice.MessageImplicitDataOutputAssociation;
import org.activiti.engine.impl.bpmn.webservice.MessageInstance;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.util.ProcessDefinitionUtil;
import org.activiti.engine.impl.util.ReflectUtil;
import org.activiti.engine.impl.webservice.WSOperation;
import org.activiti.engine.impl.webservice.WSService;
import org.apache.commons.lang3.StringUtils;

public class WebServiceActivityBehavior
extends AbstractBpmnActivityBehavior {
    private static final long serialVersionUID = 1L;
    public static final String CURRENT_MESSAGE = "org.activiti.engine.impl.bpmn.CURRENT_MESSAGE";
    protected Map<String, XMLImporter> xmlImporterMap = new HashMap<String, XMLImporter>();
    protected Map<String, WSOperation> wsOperationMap = new HashMap<String, WSOperation>();
    protected Map<String, StructureDefinition> structureDefinitionMap = new HashMap<String, StructureDefinition>();
    protected Map<String, WSService> wsServiceMap = new HashMap<String, WSService>();
    protected Map<String, org.activiti.engine.impl.bpmn.webservice.Operation> operationMap = new HashMap<String, org.activiti.engine.impl.bpmn.webservice.Operation>();
    protected Map<String, org.activiti.engine.impl.bpmn.data.ItemDefinition> itemDefinitionMap = new HashMap<String, org.activiti.engine.impl.bpmn.data.ItemDefinition>();
    protected Map<String, MessageDefinition> messageDefinitionMap = new HashMap<String, MessageDefinition>();

    public WebServiceActivityBehavior() {
        this.itemDefinitionMap.put("http://www.w3.org/2001/XMLSchema:string", new org.activiti.engine.impl.bpmn.data.ItemDefinition("http://www.w3.org/2001/XMLSchema:string", new ClassStructureDefinition(String.class)));
    }

    @Override
    public void execute(DelegateExecution execution) {
        block12: {
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(execution.getProcessDefinitionId());
            FlowElement flowElement = execution.getCurrentFlowElement();
            IOSpecification ioSpecification = null;
            String operationRef = null;
            List dataInputAssociations = null;
            List dataOutputAssociations = null;
            if (flowElement instanceof SendTask) {
                SendTask sendTask = (SendTask)flowElement;
                ioSpecification = sendTask.getIoSpecification();
                operationRef = sendTask.getOperationRef();
                dataInputAssociations = sendTask.getDataInputAssociations();
                dataOutputAssociations = sendTask.getDataOutputAssociations();
            } else if (flowElement instanceof ServiceTask) {
                ServiceTask serviceTask = (ServiceTask)flowElement;
                ioSpecification = serviceTask.getIoSpecification();
                operationRef = serviceTask.getOperationRef();
                dataInputAssociations = serviceTask.getDataInputAssociations();
                dataOutputAssociations = serviceTask.getDataOutputAssociations();
            } else {
                throw new ActivitiException("Unsupported flow element type " + String.valueOf(flowElement));
            }
            MessageInstance message = null;
            this.fillDefinitionMaps(bpmnModel);
            org.activiti.engine.impl.bpmn.webservice.Operation operation = this.operationMap.get(operationRef);
            try {
                String firstDataOutputName;
                if (ioSpecification != null) {
                    this.initializeIoSpecification(ioSpecification, execution, bpmnModel);
                    if (ioSpecification.getDataInputRefs().size() > 0) {
                        String firstDataInputName = (String)ioSpecification.getDataInputRefs().getFirst();
                        ItemInstance inputItem = (ItemInstance)execution.getVariable(firstDataInputName);
                        message = new MessageInstance(operation.getInMessage(), inputItem);
                    }
                } else {
                    message = operation.getInMessage().createInstance();
                }
                execution.setVariable(CURRENT_MESSAGE, message);
                this.fillMessage(dataInputAssociations, execution);
                ProcessEngineConfigurationImpl processEngineConfig = Context.getProcessEngineConfiguration();
                MessageInstance receivedMessage = operation.sendMessage(message, processEngineConfig.getWsOverridenEndpointAddresses());
                execution.setVariable(CURRENT_MESSAGE, receivedMessage);
                if (ioSpecification != null && ioSpecification.getDataOutputRefs().size() > 0 && (firstDataOutputName = (String)ioSpecification.getDataOutputRefs().getFirst()) != null) {
                    ItemInstance outputItem = (ItemInstance)execution.getVariable(firstDataOutputName);
                    outputItem.getStructureInstance().loadFrom(receivedMessage.getStructureInstance().toArray());
                }
                this.returnMessage(dataOutputAssociations, execution);
                execution.setVariable(CURRENT_MESSAGE, null);
                this.leave(execution);
            }
            catch (Exception exc) {
                BpmnError error = null;
                for (Throwable cause = exc; cause != null; cause = cause.getCause()) {
                    if (!(cause instanceof BpmnError)) continue;
                    error = (BpmnError)cause;
                    break;
                }
                if (error != null) {
                    ErrorPropagation.propagateError(error, execution);
                }
                if (!(exc instanceof RuntimeException)) break block12;
                throw (RuntimeException)exc;
            }
        }
    }

    protected void initializeIoSpecification(IOSpecification activityIoSpecification, DelegateExecution execution, BpmnModel bpmnModel) {
        org.activiti.engine.impl.bpmn.data.ItemDefinition itemDefinition;
        for (DataSpec dataSpec : activityIoSpecification.getDataInputs()) {
            itemDefinition = this.itemDefinitionMap.get(dataSpec.getItemSubjectRef());
            execution.setVariable(dataSpec.getId(), itemDefinition.createInstance());
        }
        for (DataSpec dataSpec : activityIoSpecification.getDataOutputs()) {
            itemDefinition = this.itemDefinitionMap.get(dataSpec.getItemSubjectRef());
            execution.setVariable(dataSpec.getId(), itemDefinition.createInstance());
        }
    }

    protected void fillDefinitionMaps(BpmnModel bpmnModel) {
        for (Import theImport : bpmnModel.getImports()) {
            this.fillImporterInfo(theImport, bpmnModel.getSourceSystemId());
        }
        this.createItemDefinitions(bpmnModel);
        this.createMessages(bpmnModel);
        this.createOperations(bpmnModel);
    }

    protected void createItemDefinitions(BpmnModel bpmnModel) {
        for (ItemDefinition itemDefinitionElement : bpmnModel.getItemDefinitions().values()) {
            if (this.itemDefinitionMap.containsKey(itemDefinitionElement.getId())) continue;
            StructureDefinition structure = null;
            try {
                Class<?> classStructure = ReflectUtil.loadClass(itemDefinitionElement.getStructureRef());
                structure = new ClassStructureDefinition(classStructure);
            }
            catch (ActivitiException e) {
                structure = this.structureDefinitionMap.get(itemDefinitionElement.getStructureRef());
            }
            org.activiti.engine.impl.bpmn.data.ItemDefinition itemDefinition = new org.activiti.engine.impl.bpmn.data.ItemDefinition(itemDefinitionElement.getId(), structure);
            if (StringUtils.isNotEmpty((CharSequence)itemDefinitionElement.getItemKind())) {
                itemDefinition.setItemKind(ItemKind.valueOf(itemDefinitionElement.getItemKind()));
            }
            this.itemDefinitionMap.put(itemDefinition.getId(), itemDefinition);
        }
    }

    public void createMessages(BpmnModel bpmnModel) {
        for (Message messageElement : bpmnModel.getMessages()) {
            if (this.messageDefinitionMap.containsKey(messageElement.getId())) continue;
            MessageDefinition messageDefinition = new MessageDefinition(messageElement.getId());
            if (StringUtils.isNotEmpty((CharSequence)messageElement.getItemRef()) && this.itemDefinitionMap.containsKey(messageElement.getItemRef())) {
                org.activiti.engine.impl.bpmn.data.ItemDefinition itemDefinition = this.itemDefinitionMap.get(messageElement.getItemRef());
                messageDefinition.setItemDefinition(itemDefinition);
            }
            this.messageDefinitionMap.put(messageDefinition.getId(), messageDefinition);
        }
    }

    protected void createOperations(BpmnModel bpmnModel) {
        for (Interface interfaceObject : bpmnModel.getInterfaces()) {
            BpmnInterface bpmnInterface = new BpmnInterface(interfaceObject.getId(), interfaceObject.getName());
            bpmnInterface.setImplementation(this.wsServiceMap.get(interfaceObject.getImplementationRef()));
            for (Operation operationObject : interfaceObject.getOperations()) {
                if (this.operationMap.containsKey(operationObject.getId())) continue;
                MessageDefinition inMessage = this.messageDefinitionMap.get(operationObject.getInMessageRef());
                org.activiti.engine.impl.bpmn.webservice.Operation operation = new org.activiti.engine.impl.bpmn.webservice.Operation(operationObject.getId(), operationObject.getName(), bpmnInterface, inMessage);
                operation.setImplementation(this.wsOperationMap.get(operationObject.getImplementationRef()));
                if (StringUtils.isNotEmpty((CharSequence)operationObject.getOutMessageRef()) && this.messageDefinitionMap.containsKey(operationObject.getOutMessageRef())) {
                    MessageDefinition outMessage = this.messageDefinitionMap.get(operationObject.getOutMessageRef());
                    operation.setOutMessage(outMessage);
                }
                this.operationMap.put(operation.getId(), operation);
            }
        }
    }

    protected void fillImporterInfo(Import theImport, String sourceSystemId) {
        if (!this.xmlImporterMap.containsKey(theImport.getImportType())) {
            if (theImport.getImportType().equals("http://schemas.xmlsoap.org/wsdl/")) {
                try {
                    Class<?> wsdlImporterClass = Class.forName("org.activiti.engine.impl.webservice.CxfWSDLImporter", true, Thread.currentThread().getContextClassLoader());
                    XMLImporter importerInstance = (XMLImporter)wsdlImporterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    this.xmlImporterMap.put(theImport.getImportType(), importerInstance);
                    importerInstance.importFrom(theImport, sourceSystemId);
                    this.structureDefinitionMap.putAll(importerInstance.getStructures());
                    this.wsServiceMap.putAll(importerInstance.getServices());
                    this.wsOperationMap.putAll(importerInstance.getOperations());
                }
                catch (Exception e) {
                    throw new ActivitiException("Could not find importer for type " + theImport.getImportType());
                }
            } else {
                throw new ActivitiException("Could not import item of type " + theImport.getImportType());
            }
        }
    }

    protected void returnMessage(List<DataAssociation> dataOutputAssociations, DelegateExecution execution) {
        for (DataAssociation dataAssociationElement : dataOutputAssociations) {
            AbstractDataAssociation dataAssociation = this.createDataOutputAssociation(dataAssociationElement);
            dataAssociation.evaluate(execution);
        }
    }

    protected void fillMessage(List<DataAssociation> dataInputAssociations, DelegateExecution execution) {
        for (DataAssociation dataAssociationElement : dataInputAssociations) {
            AbstractDataAssociation dataAssociation = this.createDataInputAssociation(dataAssociationElement);
            dataAssociation.evaluate(execution);
        }
    }

    protected AbstractDataAssociation createDataInputAssociation(DataAssociation dataAssociationElement) {
        if (dataAssociationElement.getAssignments().isEmpty()) {
            return new MessageImplicitDataInputAssociation(dataAssociationElement.getSourceRef(), dataAssociationElement.getTargetRef());
        }
        SimpleDataInputAssociation dataAssociation = new SimpleDataInputAssociation(dataAssociationElement.getSourceRef(), dataAssociationElement.getTargetRef());
        ExpressionManager expressionManager = Context.getProcessEngineConfiguration().getExpressionManager();
        for (Assignment assignmentElement : dataAssociationElement.getAssignments()) {
            if (!StringUtils.isNotEmpty((CharSequence)assignmentElement.getFrom()) || !StringUtils.isNotEmpty((CharSequence)assignmentElement.getTo())) continue;
            Expression from = expressionManager.createExpression(assignmentElement.getFrom());
            Expression to = expressionManager.createExpression(assignmentElement.getTo());
            org.activiti.engine.impl.bpmn.data.Assignment assignment = new org.activiti.engine.impl.bpmn.data.Assignment(from, to);
            dataAssociation.addAssignment(assignment);
        }
        return dataAssociation;
    }

    protected AbstractDataAssociation createDataOutputAssociation(DataAssociation dataAssociationElement) {
        if (StringUtils.isNotEmpty((CharSequence)dataAssociationElement.getSourceRef())) {
            return new MessageImplicitDataOutputAssociation(dataAssociationElement.getTargetRef(), dataAssociationElement.getSourceRef());
        }
        ExpressionManager expressionManager = Context.getProcessEngineConfiguration().getExpressionManager();
        Expression transformation = expressionManager.createExpression(dataAssociationElement.getTransformation());
        TransformationDataOutputAssociation dataOutputAssociation = new TransformationDataOutputAssociation(null, dataAssociationElement.getTargetRef(), transformation);
        return dataOutputAssociation;
    }
}

