/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CancelEventDefinition;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.Error;
import org.activiti.bpmn.model.ErrorEventDefinition;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.Message;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.TerminateEventDefinition;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractActivityBpmnParseHandler;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndEventParseHandler
extends AbstractActivityBpmnParseHandler<EndEvent> {
    private static final Logger logger = LoggerFactory.getLogger(EndEventParseHandler.class);

    @Override
    public Class<? extends BaseElement> getHandledType() {
        return EndEvent.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, EndEvent endEvent) {
        EventDefinition eventDefinition = null;
        if (endEvent.getEventDefinitions().size() > 0) {
            eventDefinition = (EventDefinition)endEvent.getEventDefinitions().getFirst();
            if (eventDefinition instanceof ErrorEventDefinition) {
                ErrorEventDefinition errorDefinition = (ErrorEventDefinition)eventDefinition;
                if (bpmnParse.getBpmnModel().containsErrorRef(errorDefinition.getErrorRef())) {
                    for (Error error : bpmnParse.getBpmnModel().getErrors().values()) {
                        String errorCode = null;
                        if (error.getId().equals(errorDefinition.getErrorRef())) {
                            errorCode = error.getErrorCode();
                        }
                        if (!StringUtils.isEmpty(errorCode)) continue;
                        logger.warn("errorCode is required for an error event " + endEvent.getId());
                    }
                }
                endEvent.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createErrorEndEventActivityBehavior(endEvent, errorDefinition));
            } else if (eventDefinition instanceof TerminateEventDefinition) {
                endEvent.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createTerminateEndEventActivityBehavior(endEvent));
            } else if (eventDefinition instanceof CancelEventDefinition) {
                endEvent.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createCancelEndEventActivityBehavior(endEvent));
            } else if (eventDefinition instanceof MessageEventDefinition) {
                MessageEventDefinition messageEventDefinition = (MessageEventDefinition)MessageEventDefinition.class.cast(eventDefinition);
                Message message = bpmnParse.getBpmnModel().getMessage(messageEventDefinition.getMessageRef());
                BpmnModel bpmnModel = bpmnParse.getBpmnModel();
                if (bpmnModel.containsMessageId(messageEventDefinition.getMessageRef())) {
                    messageEventDefinition.setMessageRef(message.getName());
                    messageEventDefinition.setExtensionElements(message.getExtensionElements());
                }
                endEvent.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createThrowMessageEndEventActivityBehavior(endEvent, messageEventDefinition, message));
            } else {
                endEvent.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createNoneEndEventActivityBehavior(endEvent));
            }
        } else {
            endEvent.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createNoneEndEventActivityBehavior(endEvent));
        }
    }
}

