/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CompensateEventDefinition;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.LinkEventDefinition;
import org.activiti.bpmn.model.Message;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.ThrowEvent;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractActivityBpmnParseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntermediateThrowEventParseHandler
extends AbstractActivityBpmnParseHandler<ThrowEvent> {
    private static final Logger logger = LoggerFactory.getLogger(IntermediateThrowEventParseHandler.class);

    @Override
    public Class<? extends BaseElement> getHandledType() {
        return ThrowEvent.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, ThrowEvent intermediateEvent) {
        EventDefinition eventDefinition = null;
        if (!intermediateEvent.getEventDefinitions().isEmpty()) {
            eventDefinition = (EventDefinition)intermediateEvent.getEventDefinitions().getFirst();
        }
        if (eventDefinition instanceof SignalEventDefinition) {
            SignalEventDefinition signalEventDefinition = (SignalEventDefinition)eventDefinition;
            intermediateEvent.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createIntermediateThrowSignalEventActivityBehavior(intermediateEvent, signalEventDefinition, bpmnParse.getBpmnModel().getSignal(signalEventDefinition.getSignalRef())));
        } else if (eventDefinition instanceof CompensateEventDefinition) {
            CompensateEventDefinition compensateEventDefinition = (CompensateEventDefinition)eventDefinition;
            intermediateEvent.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createIntermediateThrowCompensationEventActivityBehavior(intermediateEvent, compensateEventDefinition));
        } else if (eventDefinition instanceof MessageEventDefinition) {
            MessageEventDefinition messageEventDefinition = (MessageEventDefinition)eventDefinition;
            Message message = bpmnParse.getBpmnModel().getMessage(messageEventDefinition.getMessageRef());
            BpmnModel bpmnModel = bpmnParse.getBpmnModel();
            if (bpmnModel.containsMessageId(messageEventDefinition.getMessageRef())) {
                messageEventDefinition.setMessageRef(message.getName());
                messageEventDefinition.setExtensionElements(message.getExtensionElements());
            }
            intermediateEvent.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createThrowMessageEventActivityBehavior(intermediateEvent, messageEventDefinition, message));
        } else if (eventDefinition instanceof LinkEventDefinition) {
            LinkEventDefinition linkEventDefinition = (LinkEventDefinition)eventDefinition;
            intermediateEvent.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createThrowLinkEventActivityBehavior(intermediateEvent, linkEventDefinition));
        } else if (eventDefinition == null) {
            intermediateEvent.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createIntermediateThrowNoneEventActivityBehavior(intermediateEvent));
        } else {
            logger.warn("Unsupported intermediate throw event type for throw event " + intermediateEvent.getId());
        }
    }
}

