/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.bpmn.helper.task.TaskUpdater;
import org.activiti.engine.impl.history.HistoryLevel;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;

public class SaveTaskCmd
implements Command<Task>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected TaskEntity task;

    public SaveTaskCmd(Task task) {
        this.task = (TaskEntity)task;
    }

    @Override
    public Task execute(CommandContext commandContext) {
        if (this.task == null) {
            throw new ActivitiIllegalArgumentException("task is null");
        }
        if (this.task.getRevision() == 0) {
            commandContext.getTaskEntityManager().insert(this.task, null);
            if (commandContext.getEventDispatcher().isEnabled()) {
                commandContext.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.TASK_CREATED, this.task));
                if (this.task.getAssignee() != null) {
                    commandContext.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.TASK_ASSIGNED, this.task));
                }
            }
        } else {
            TaskInfo originalTaskEntity = null;
            if (commandContext.getProcessEngineConfiguration().getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
                originalTaskEntity = (TaskInfo)commandContext.getHistoricTaskInstanceEntityManager().findById(this.task.getId());
            }
            if (originalTaskEntity == null) {
                originalTaskEntity = (TaskInfo)commandContext.getTaskEntityManager().findById(this.task.getId());
            }
            TaskUpdater taskUpdater = new TaskUpdater(commandContext);
            taskUpdater.updateTask(originalTaskEntity, this.task);
            return commandContext.getTaskEntityManager().update(this.task);
        }
        return null;
    }
}

