/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.asyncexecutor;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.activiti.engine.ActivitiOptimisticLockingException;
import org.activiti.engine.impl.asyncexecutor.AcquiredTimerJobEntities;
import org.activiti.engine.impl.asyncexecutor.AsyncExecutor;
import org.activiti.engine.impl.asyncexecutor.JobManager;
import org.activiti.engine.impl.cmd.AcquireTimerJobsCmd;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.persistence.entity.TimerJobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcquireTimerJobsRunnable
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(AcquireTimerJobsRunnable.class);
    protected final AsyncExecutor asyncExecutor;
    protected final JobManager jobManager;
    protected volatile boolean isInterrupted;
    protected final Object MONITOR = new Object();
    protected final AtomicBoolean isWaiting = new AtomicBoolean(false);
    protected long millisToWait;

    public AcquireTimerJobsRunnable(AsyncExecutor asyncExecutor, JobManager jobManager) {
        this.asyncExecutor = asyncExecutor;
        this.jobManager = jobManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        log.info("{} starting to acquire async jobs due");
        Thread.currentThread().setName("activiti-acquire-timer-jobs");
        CommandExecutor commandExecutor = this.asyncExecutor.getProcessEngineConfiguration().getCommandExecutor();
        while (!this.isInterrupted) {
            try {
                final AcquiredTimerJobEntities acquiredJobs = commandExecutor.execute(new AcquireTimerJobsCmd(this.asyncExecutor));
                commandExecutor.execute(new Command<Void>(){
                    final /* synthetic */ AcquireTimerJobsRunnable this$0;
                    {
                        AcquireTimerJobsRunnable acquireTimerJobsRunnable = this$0;
                        Objects.requireNonNull(acquireTimerJobsRunnable);
                        this.this$0 = acquireTimerJobsRunnable;
                    }

                    @Override
                    public Void execute(CommandContext commandContext) {
                        for (TimerJobEntity job : acquiredJobs.getJobs()) {
                            this.this$0.jobManager.moveTimerJobToExecutableJob(job);
                        }
                        return null;
                    }
                });
                this.millisToWait = this.asyncExecutor.getDefaultTimerJobAcquireWaitTimeInMillis();
                int jobsAcquired = acquiredJobs.size();
                if (jobsAcquired >= this.asyncExecutor.getMaxTimerJobsPerAcquisition()) {
                    this.millisToWait = 0L;
                }
            }
            catch (ActivitiOptimisticLockingException optimisticLockingException) {
                if (log.isDebugEnabled()) {
                    log.debug("Optimistic locking exception during timer job acquisition. If you have multiple timer executors running against the same database, this exception means that this thread tried to acquire a timer job, which already was acquired by another timer executor acquisition thread.This is expected behavior in a clustered environment. You can ignore this message if you indeed have multiple timer executor acquisition threads running against the same database. Exception message: {}", (Object)optimisticLockingException.getMessage());
                }
            }
            catch (Throwable e) {
                log.error("exception during timer job acquisition: {}", (Object)e.getMessage(), (Object)e);
                this.millisToWait = this.asyncExecutor.getDefaultTimerJobAcquireWaitTimeInMillis();
            }
            if (this.millisToWait <= 0L) continue;
            try {
                if (log.isDebugEnabled()) {
                    log.debug("timer job acquisition thread sleeping for {} millis", (Object)this.millisToWait);
                }
                Object e = this.MONITOR;
                synchronized (e) {
                    if (!this.isInterrupted) {
                        this.isWaiting.set(true);
                        this.MONITOR.wait(this.millisToWait);
                    }
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("timer job acquisition thread woke up");
            }
            catch (InterruptedException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("timer job acquisition wait interrupted");
            }
            finally {
                this.isWaiting.set(false);
            }
        }
        log.info("{} stopped async job due acquisition");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.MONITOR;
        synchronized (object) {
            this.isInterrupted = true;
            if (this.isWaiting.compareAndSet(true, false)) {
                this.MONITOR.notifyAll();
            }
        }
    }

    public long getMillisToWait() {
        return this.millisToWait;
    }

    public void setMillisToWait(long millisToWait) {
        this.millisToWait = millisToWait;
    }
}

