/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.core.el;

import jakarta.el.CompositeELResolver;
import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.activiti.core.el.ActivitiElContext;
import org.activiti.core.el.CustomFunctionProvider;
import org.activiti.core.el.DateResolverHelper;
import org.activiti.core.el.ListResolverHelper;
import org.activiti.core.el.ReadOnlyMapELResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ELContextBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ELContextBuilder.class);
    private List<ELResolver> resolvers;
    private Map<String, Object> variables;

    public ELContextBuilder withResolvers(ELResolver ... resolvers) {
        this.resolvers = List.of(resolvers);
        return this;
    }

    public ELContextBuilder withVariables(Map<String, Object> variables) {
        this.variables = variables;
        return this;
    }

    public ELContext build() {
        CompositeELResolver elResolver = this.createCompositeResolver();
        return new ActivitiElContext((ELResolver)elResolver);
    }

    public ELContext buildWithCustomFunctions(List<CustomFunctionProvider> customFunctionProviders) {
        CompositeELResolver elResolver = this.createCompositeResolver();
        ActivitiElContext elContext = new ActivitiElContext((ELResolver)elResolver);
        try {
            DateResolverHelper.addDateFunctions(elContext);
            ListResolverHelper.addListFunctions(elContext);
            if (customFunctionProviders != null) {
                customFunctionProviders.forEach(provider -> {
                    try {
                        provider.addCustomFunctions(elContext);
                    }
                    catch (Exception e) {
                        logger.error("Error setting up EL custom functions", (Throwable)e);
                    }
                });
            }
        }
        catch (NoSuchMethodException e) {
            logger.error("Error setting up EL custom functions", (Throwable)e);
        }
        return elContext;
    }

    private void addResolvers(CompositeELResolver compositeResolver) {
        Stream.ofNullable(this.resolvers).flatMap(Collection::stream).forEach(arg_0 -> ((CompositeELResolver)compositeResolver).add(arg_0));
    }

    private CompositeELResolver createCompositeResolver() {
        CompositeELResolver elResolver = new CompositeELResolver();
        elResolver.add((ELResolver)new ReadOnlyMapELResolver((Map<Object, Object>)(Objects.nonNull(this.variables) ? new HashMap<String, Object>(this.variables) : Collections.emptyMap())));
        this.addResolvers(elResolver);
        return elResolver;
    }
}

