/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.core.el;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.PropertyNotWritableException;
import java.beans.FeatureDescriptor;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class JsonNodeELResolver
extends ELResolver {
    private final boolean readOnly;
    private final ObjectMapper defaultObjectMapper = new ObjectMapper();

    public JsonNodeELResolver() {
        this(false);
    }

    public JsonNodeELResolver(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        return this.isResolvable(base) ? Object.class : null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (this.isResolvable(base)) {
            JsonNode node = (JsonNode)base;
            final Iterator keys = node.fieldNames();
            return new Iterator<FeatureDescriptor>(){
                {
                    Objects.requireNonNull(this$0);
                }

                @Override
                public boolean hasNext() {
                    return keys.hasNext();
                }

                @Override
                public FeatureDescriptor next() {
                    Object key = keys.next();
                    FeatureDescriptor feature = new FeatureDescriptor();
                    feature.setDisplayName(key == null ? "null" : key.toString());
                    feature.setName(feature.getDisplayName());
                    feature.setShortDescription("");
                    feature.setExpert(true);
                    feature.setHidden(false);
                    feature.setPreferred(true);
                    feature.setValue("type", key == null ? "null" : key.getClass());
                    feature.setValue("resolvableAtDesignTime", true);
                    return feature;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("cannot remove");
                }
            };
        }
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        Class<Object> result = null;
        if (this.isResolvable(base)) {
            result = Object.class;
            context.setPropertyResolved(true);
        }
        return result;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        Object result = null;
        if (this.isResolvable(base)) {
            JsonNode resultNode = ((JsonNode)base).get(property.toString());
            result = resultNode != null && resultNode.isValueNode() ? (resultNode.isBoolean() ? Boolean.valueOf(resultNode.asBoolean()) : (resultNode.isLong() ? Long.valueOf(resultNode.asLong()) : (resultNode.isBigDecimal() || resultNode.isDouble() ? Double.valueOf(resultNode.asDouble()) : (resultNode.isTextual() ? resultNode.asText() : resultNode.toString())))) : (resultNode.isArray() ? this.getObjectMapper().convertValue((Object)resultNode, List.class) : resultNode);
            context.setPropertyResolved(true);
        }
        return result;
    }

    protected ObjectMapper getObjectMapper() {
        return this.defaultObjectMapper;
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        if (this.isResolvable(base)) {
            context.setPropertyResolved(true);
        }
        return this.readOnly;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        if (base instanceof ObjectNode) {
            ObjectNode node = (ObjectNode)base;
            if (this.readOnly) {
                throw new PropertyNotWritableException("resolver is read-only");
            }
            if (value instanceof BigDecimal) {
                BigDecimal decimal = (BigDecimal)value;
                node.put(property.toString(), decimal);
            } else if (value instanceof Boolean) {
                Boolean booleanValue = (Boolean)value;
                node.put(property.toString(), booleanValue);
            } else if (value instanceof Long) {
                Long longValue = (Long)value;
                node.put(property.toString(), longValue);
            } else if (value instanceof Double) {
                Double doubleValue = (Double)value;
                node.put(property.toString(), doubleValue);
            } else if (value != null) {
                node.put(property.toString(), value.toString());
            } else {
                node.putNull(property.toString());
            }
            context.setPropertyResolved(true);
        }
    }

    private final boolean isResolvable(Object base) {
        return base instanceof JsonNode;
    }
}

