/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.CancelEventDefinition;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.ErrorEventDefinition;
import org.activiti.bpmn.model.Event;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.TerminateEventDefinition;
import org.activiti.editor.language.json.converter.BaseBpmnJsonConverter;
import org.activiti.editor.language.json.converter.BpmnJsonConverterUtil;
import org.apache.commons.lang3.StringUtils;

public class EndEventJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        EndEventJsonConverter.fillJsonTypes(convertersToBpmnMap);
        EndEventJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("EndNoneEvent", EndEventJsonConverter.class);
        convertersToBpmnMap.put("EndErrorEvent", EndEventJsonConverter.class);
        convertersToBpmnMap.put("EndCancelEvent", EndEventJsonConverter.class);
        convertersToBpmnMap.put("EndTerminateEvent", EndEventJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(EndEvent.class, EndEventJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        EndEvent endEvent = (EndEvent)baseElement;
        List eventDefinitions = endEvent.getEventDefinitions();
        if (eventDefinitions.size() != 1) {
            return "EndNoneEvent";
        }
        EventDefinition eventDefinition = (EventDefinition)eventDefinitions.getFirst();
        if (eventDefinition instanceof ErrorEventDefinition) {
            return "EndErrorEvent";
        }
        if (eventDefinition instanceof CancelEventDefinition) {
            return "EndCancelEvent";
        }
        if (eventDefinition instanceof TerminateEventDefinition) {
            return "EndTerminateEvent";
        }
        return "EndNoneEvent";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
        EndEvent endEvent = (EndEvent)baseElement;
        this.addEventProperties((Event)endEvent, propertiesNode);
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        EndEvent endEvent = new EndEvent();
        String stencilId = BpmnJsonConverterUtil.getStencilId(elementNode);
        if ("EndErrorEvent".equals(stencilId)) {
            this.convertJsonToErrorDefinition(elementNode, (Event)endEvent);
        } else if ("EndCancelEvent".equals(stencilId)) {
            CancelEventDefinition eventDefinition = new CancelEventDefinition();
            endEvent.getEventDefinitions().add(eventDefinition);
        } else if ("EndTerminateEvent".equals(stencilId)) {
            String terminateMiStringValue;
            TerminateEventDefinition eventDefinition = new TerminateEventDefinition();
            String terminateAllStringValue = this.getPropertyValueAsString("terminateall", elementNode);
            if (StringUtils.isNotEmpty((CharSequence)terminateAllStringValue)) {
                eventDefinition.setTerminateAll("true".equals(terminateAllStringValue));
            }
            if (StringUtils.isNotEmpty((CharSequence)(terminateMiStringValue = this.getPropertyValueAsString("terminateMultiInstance", elementNode)))) {
                eventDefinition.setTerminateMultiInstance("true".equals(terminateMiStringValue));
            }
            endEvent.getEventDefinitions().add(eventDefinition);
        }
        return endEvent;
    }
}

