/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.core.el.juel.util;

import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.FunctionMapper;
import jakarta.el.ValueExpression;
import jakarta.el.VariableMapper;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.activiti.core.el.juel.util.SimpleResolver;

public class SimpleContext
extends ELContext {
    private Functions functions;
    private Variables variables;
    private ELResolver resolver;

    public SimpleContext() {
        this(null);
    }

    public SimpleContext(ELResolver resolver) {
        this.resolver = resolver;
    }

    public void setFunction(String prefix, String localName, Method method) {
        if (this.functions == null) {
            this.functions = new Functions();
        }
        this.functions.setFunction(prefix, localName, method);
    }

    public ValueExpression setVariable(String name, ValueExpression expression) {
        if (this.variables == null) {
            this.variables = new Variables();
        }
        return this.variables.setVariable(name, expression);
    }

    public FunctionMapper getFunctionMapper() {
        if (this.functions == null) {
            this.functions = new Functions();
        }
        return this.functions;
    }

    public VariableMapper getVariableMapper() {
        if (this.variables == null) {
            this.variables = new Variables();
        }
        return this.variables;
    }

    public ELResolver getELResolver() {
        if (this.resolver == null) {
            this.resolver = new SimpleResolver();
        }
        return this.resolver;
    }

    public void setELResolver(ELResolver resolver) {
        this.resolver = resolver;
    }

    static class Functions
    extends FunctionMapper {
        Map<String, Method> map = Collections.emptyMap();

        Functions() {
        }

        public Method resolveFunction(String prefix, String localName) {
            return this.map.get(prefix + ":" + localName);
        }

        public void setFunction(String prefix, String localName, Method method) {
            if (this.map.isEmpty()) {
                this.map = new HashMap<String, Method>();
            }
            this.map.put(prefix + ":" + localName, method);
        }
    }

    static class Variables
    extends VariableMapper {
        Map<String, ValueExpression> map = Collections.emptyMap();

        Variables() {
        }

        public ValueExpression resolveVariable(String variable) {
            return this.map.get(variable);
        }

        public ValueExpression setVariable(String variable, ValueExpression expression) {
            if (this.map.isEmpty()) {
                this.map = new HashMap<String, ValueExpression>();
            }
            return this.map.put(variable, expression);
        }
    }
}

