/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.validation.validator.impl;

import java.util.List;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ErrorEventDefinition;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.EventSubProcess;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.validation.ValidationError;
import org.activiti.validation.validator.ProcessLevelValidator;

public class EventSubprocessValidator
extends ProcessLevelValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        List eventSubprocesses = process.findFlowElementsOfType(EventSubProcess.class);
        for (EventSubProcess eventSubprocess : eventSubprocesses) {
            List startEvents = process.findFlowElementsInSubProcessOfType((SubProcess)eventSubprocess, StartEvent.class);
            for (StartEvent startEvent : startEvents) {
                EventDefinition eventDefinition;
                if (startEvent.getEventDefinitions() == null || startEvent.getEventDefinitions().isEmpty() || (eventDefinition = (EventDefinition)startEvent.getEventDefinitions().getFirst()) instanceof ErrorEventDefinition || eventDefinition instanceof MessageEventDefinition || eventDefinition instanceof SignalEventDefinition) continue;
                this.addError(errors, "EVENT_SUBPROCESS_INVALID_START_EVENT_DEFINITION", process, (BaseElement)eventSubprocess);
            }
        }
    }
}

