/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.boot;

import java.util.List;
import java.util.Objects;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.impl.bpmn.deployer.BpmnDeploymentHelper;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.spring.SpringProcessEngineConfiguration;
import org.activiti.spring.boot.ProcessEngineConfigurationConfigurer;

public class CandidateStartersDeploymentConfigurer
implements ProcessEngineConfigurationConfigurer {
    private static final String EVERYONE_GROUP = "*";

    @Override
    public void configure(SpringProcessEngineConfiguration processEngineConfiguration) {
        processEngineConfiguration.setBpmnDeploymentHelper((BpmnDeploymentHelper)new CandidateStartersDeploymentHelper(this));
    }

    public class CandidateStartersDeploymentHelper
    extends BpmnDeploymentHelper {
        public CandidateStartersDeploymentHelper(CandidateStartersDeploymentConfigurer this$0) {
            Objects.requireNonNull(this$0);
        }

        public void addAuthorizationsForNewProcessDefinition(Process process, ProcessDefinitionEntity processDefinition) {
            super.addAuthorizationsForNewProcessDefinition(process, processDefinition);
            if (process != null && !process.isCandidateStarterUsersDefined() && !process.isCandidateStarterGroupsDefined()) {
                this.addAuthorizationsFromIterator(Context.getCommandContext(), List.of(CandidateStartersDeploymentConfigurer.EVERYONE_GROUP), processDefinition, BpmnDeploymentHelper.ExpressionType.GROUP);
            }
        }
    }
}

