/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.boot;

import org.activiti.engine.ApplicationStatusHolder;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.core.PriorityOrdered;

public class ShutdownListener
implements ApplicationListener<ContextClosedEvent>,
PriorityOrdered {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShutdownListener.class);
    private final ProcessEngineConfigurationImpl processEngineConfiguration;

    public ShutdownListener(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        if (event.getApplicationContext().getParent() == null) {
            LOGGER.info("Setting application status to shutdown");
            this.processEngineConfiguration.getAsyncExecutor().shutdown();
            ApplicationStatusHolder.shutdown();
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

