/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.autoconfigure.cache.CacheProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="activiti.spring.cache-manager")
public class ActivitiSpringCacheManagerProperties {
    private boolean enabled = true;
    private CacheProvider provider = CacheProvider.caffeine;
    private final Map<String, ActivitiCacheProperties> caches = new LinkedHashMap<String, ActivitiCacheProperties>();
    private CaffeineCacheProviderProperties caffeine = new CaffeineCacheProviderProperties();
    private SimpleCacheProviderProperties simple = new SimpleCacheProviderProperties();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public CacheProvider getProvider() {
        return this.provider;
    }

    public void setProvider(CacheProvider provider) {
        this.provider = provider;
    }

    public Map<String, ActivitiCacheProperties> getCaches() {
        return this.caches;
    }

    public CaffeineCacheProviderProperties getCaffeine() {
        return this.caffeine;
    }

    public SimpleCacheProviderProperties getSimple() {
        return this.simple;
    }

    public void setCaffeine(CaffeineCacheProviderProperties caffeine) {
        this.caffeine = caffeine;
    }

    public void setSimple(SimpleCacheProviderProperties simple) {
        this.simple = simple;
    }

    public static enum CacheProvider {
        noop,
        simple,
        caffeine;

    }

    public static class CaffeineCacheProviderProperties {
        private boolean allowNullValues = true;
        private boolean useSystemScheduler = true;
        private String defaultSpec = "";

        public boolean isAllowNullValues() {
            return this.allowNullValues;
        }

        public String getDefaultSpec() {
            return this.defaultSpec;
        }

        public void setAllowNullValues(boolean allowNullValues) {
            this.allowNullValues = allowNullValues;
        }

        public void setDefaultSpec(String defaultSpec) {
            this.defaultSpec = defaultSpec;
        }

        public boolean isUseSystemScheduler() {
            return this.useSystemScheduler;
        }

        public void setUseSystemScheduler(boolean useSystemScheduler) {
            this.useSystemScheduler = useSystemScheduler;
        }
    }

    public static class SimpleCacheProviderProperties {
        private boolean allowNullValues = true;

        public boolean isAllowNullValues() {
            return this.allowNullValues;
        }

        public void setAllowNullValues(boolean allowNullValues) {
            this.allowNullValues = allowNullValues;
        }
    }

    public static class ActivitiCacheProperties {
        private boolean enabled = true;
        private CacheProperties.Caffeine caffeine = new CacheProperties.Caffeine();

        public CacheProperties.Caffeine getCaffeine() {
            return this.caffeine;
        }

        public void setCaffeine(CacheProperties.Caffeine caffeine) {
            this.caffeine = caffeine;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

