/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.process;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.spring.process.ProcessExtensionRepository;
import org.activiti.spring.process.ProcessExtensionResourceReader;
import org.activiti.spring.process.model.Extension;
import org.activiti.spring.process.model.ProcessExtensionModel;
import org.activiti.spring.resources.DeploymentResourceLoader;
import org.activiti.spring.resources.ResourceReader;
import org.springframework.lang.NonNull;

public class ProcessExtensionRepositoryImpl
implements ProcessExtensionRepository {
    private final DeploymentResourceLoader<ProcessExtensionModel> processExtensionLoader;
    private final ProcessExtensionResourceReader processExtensionReader;
    private final RepositoryService repositoryService;

    public ProcessExtensionRepositoryImpl(DeploymentResourceLoader<ProcessExtensionModel> processExtensionLoader, ProcessExtensionResourceReader processExtensionReader, RepositoryService repositoryService) {
        this.processExtensionLoader = processExtensionLoader;
        this.processExtensionReader = processExtensionReader;
        this.repositoryService = repositoryService;
    }

    @Override
    public Optional<Extension> getExtensionsForId(@NonNull String processDefinitionId) {
        return Optional.of(processDefinitionId).map(arg_0 -> ((RepositoryService)this.repositoryService).getProcessDefinition(arg_0)).map(this::fetchExtensionsFor);
    }

    @Override
    public Optional<Extension> getExtensionsFor(ProcessDefinition processDefinition) {
        return Optional.ofNullable(this.fetchExtensionsFor(processDefinition));
    }

    private Extension fetchExtensionsFor(ProcessDefinition processDefinition) {
        Map<String, Extension> processExtensionModelMap = this.getProcessExtensionsForDeploymentId(processDefinition.getDeploymentId());
        return processExtensionModelMap.get(processDefinition.getKey());
    }

    private Map<String, Extension> getProcessExtensionsForDeploymentId(String deploymentId) {
        List processExtensionModels = this.processExtensionLoader.loadResourcesForDeployment(deploymentId, (ResourceReader)this.processExtensionReader);
        return processExtensionModels.stream().flatMap(it -> it.getAllExtensions().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

