/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.api.process.model.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.activiti.api.process.model.IntegrationContext;
import org.activiti.cloud.api.model.shared.impl.CloudRuntimeEntityImpl;
import org.activiti.cloud.api.process.model.CloudBpmnError;
import org.activiti.cloud.api.process.model.IntegrationError;
import org.activiti.cloud.api.process.model.IntegrationRequest;

public class IntegrationErrorImpl
extends CloudRuntimeEntityImpl
implements IntegrationError {
    private IntegrationRequest integrationRequest;
    private IntegrationContext integrationContext;
    private String errorCode;
    private String errorMessage;
    private List<StackTraceElement> stackTraceElements;
    private String errorClassName;

    IntegrationErrorImpl() {
    }

    public IntegrationErrorImpl(IntegrationRequest integrationRequest, Throwable error) {
        this.integrationRequest = integrationRequest;
        this.integrationContext = integrationRequest.getIntegrationContext();
        this.errorClassName = error.getClass().getName();
        this.errorCode = Optional.of(error).filter(CloudBpmnError.class::isInstance).map(CloudBpmnError.class::cast).map(CloudBpmnError::getErrorCode).orElse(null);
        Throwable cause = this.findRootCause(error);
        this.errorMessage = cause.getMessage();
        this.stackTraceElements = Arrays.asList(cause.getStackTrace());
    }

    public IntegrationContext getIntegrationContext() {
        return this.integrationContext;
    }

    public IntegrationRequest getIntegrationRequest() {
        return this.integrationRequest;
    }

    public List<StackTraceElement> getStackTraceElements() {
        return this.stackTraceElements;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorClassName() {
        return this.errorClassName;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.errorClassName, this.errorMessage, this.integrationContext, this.integrationRequest, this.stackTraceElements);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        IntegrationErrorImpl other = (IntegrationErrorImpl)((Object)obj);
        return Objects.equals(this.errorClassName, other.errorClassName) && Objects.equals(this.errorMessage, other.errorMessage) && Objects.equals(this.integrationContext, other.integrationContext) && Objects.equals(this.integrationRequest, other.integrationRequest) && Objects.equals(this.stackTraceElements, other.stackTraceElements);
    }

    public String toString() {
        int maxLen = 10;
        StringBuilder builder = new StringBuilder();
        builder.append("IntegrationErrorImpl [integrationRequest=").append(this.integrationRequest).append(", integrationContext=").append(this.integrationContext).append(", errorMessage=").append(this.errorMessage).append(", stackTraceElements=").append(this.stackTraceElements != null ? this.stackTraceElements.subList(0, Math.min(this.stackTraceElements.size(), 10)) : null).append(", errorClassName=").append(this.errorClassName).append(", toString()=").append(super.toString()).append("]");
        return builder.toString();
    }

    protected Throwable findRootCause(Throwable throwable) {
        Throwable rootCause;
        for (rootCause = Objects.requireNonNull(throwable); rootCause.getCause() != null && rootCause.getCause() != rootCause; rootCause = rootCause.getCause()) {
        }
        return rootCause;
    }
}

