/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.api.task.model.impl;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.activiti.api.model.shared.model.ApplicationElement;
import org.activiti.api.task.model.Task;
import org.activiti.cloud.api.model.shared.impl.CloudRuntimeEntityImpl;
import org.activiti.cloud.api.task.model.CloudTask;

public class CloudTaskImpl
extends CloudRuntimeEntityImpl
implements CloudTask {
    private String id;
    private String owner;
    private String assignee;
    private String name;
    private String description;
    private Date createdDate;
    private Date claimedDate;
    private Date dueDate;
    private int priority;
    private String processDefinitionId;
    private String processInstanceId;
    private String parentTaskId;
    private String formKey;
    private String completedBy;
    private Task.TaskStatus status;
    private Date completedDate;
    private Long duration;
    private Integer processDefinitionVersion;
    private String businessKey;
    private String taskDefinitionKey;
    private List<String> candidateUsers;
    private List<String> candidateGroups;

    public CloudTaskImpl() {
    }

    public CloudTaskImpl(Task task) {
        super((ApplicationElement)task);
        this.id = task.getId();
        this.owner = task.getOwner();
        this.assignee = task.getAssignee();
        this.name = task.getName();
        this.description = task.getDescription();
        this.createdDate = task.getCreatedDate();
        this.claimedDate = task.getClaimedDate();
        this.dueDate = task.getDueDate();
        this.priority = task.getPriority();
        this.processDefinitionId = task.getProcessDefinitionId();
        this.processInstanceId = task.getProcessInstanceId();
        this.parentTaskId = task.getParentTaskId();
        this.formKey = task.getFormKey();
        this.status = task.getStatus();
        this.processDefinitionVersion = task.getProcessDefinitionVersion();
        this.businessKey = task.getBusinessKey();
        this.taskDefinitionKey = task.getTaskDefinitionKey();
        this.candidateUsers = task.getCandidateUsers();
        this.candidateGroups = task.getCandidateGroups();
    }

    public List<String> getCandidateGroups() {
        return this.candidateGroups;
    }

    public void setCandidateGroups(List<String> candidateGroups) {
        this.candidateGroups = candidateGroups;
    }

    public List<String> getCandidateUsers() {
        return this.candidateUsers;
    }

    public void setCandidateUsers(List<String> candidateUsers) {
        this.candidateUsers = candidateUsers;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Date getClaimedDate() {
        return this.claimedDate;
    }

    public void setClaimedDate(Date claimedDate) {
        this.claimedDate = claimedDate;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public Integer getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    public void setProcessDefinitionVersion(Integer processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public boolean isStandalone() {
        return this.getProcessInstanceId() == null;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    public String getParentTaskId() {
        return this.parentTaskId;
    }

    public void setParentTaskId(String parentTaskId) {
        this.parentTaskId = parentTaskId;
    }

    public String getFormKey() {
        return this.formKey;
    }

    public void setFormKey(String formKey) {
        this.formKey = formKey;
    }

    public Task.TaskStatus getStatus() {
        return this.status;
    }

    public void setStatus(Task.TaskStatus status) {
        this.status = status;
    }

    public Date getCompletedDate() {
        return this.completedDate;
    }

    public void setCompletedDate(Date completedDate) {
        this.completedDate = completedDate;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public Long getDuration() {
        return this.duration;
    }

    public String getTaskDefinitionKey() {
        return this.taskDefinitionKey;
    }

    public void setTaskDefinitionKey(String taskDefinitionKey) {
        this.taskDefinitionKey = taskDefinitionKey;
    }

    public String getCompletedBy() {
        return this.completedBy;
    }

    public void setCompletedBy(String completedBy) {
        this.completedBy = completedBy;
    }

    public String toString() {
        return "CloudTaskImpl{id='" + this.id + "', owner='" + this.owner + "', assignee='" + this.assignee + "', name='" + this.name + "', description='" + this.description + "', createdDate=" + this.createdDate + ", claimedDate=" + this.claimedDate + ", dueDate=" + this.dueDate + ", priority=" + this.priority + ", processDefinitionId='" + this.processDefinitionId + "', processInstanceId='" + this.processInstanceId + "', parentTaskId='" + this.parentTaskId + "', formKey='" + this.formKey + "', status=" + this.status + ", processDefinitionVersion=" + this.processDefinitionVersion + ", businessKey=" + this.businessKey + ", taskDefinitionKey=" + this.taskDefinitionKey + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CloudTaskImpl task = (CloudTaskImpl)((Object)o);
        return this.priority == task.priority && Objects.equals(this.id, task.id) && Objects.equals(this.owner, task.owner) && Objects.equals(this.assignee, task.assignee) && Objects.equals(this.name, task.name) && Objects.equals(this.description, task.description) && Objects.equals(this.createdDate, task.createdDate) && Objects.equals(this.claimedDate, task.claimedDate) && Objects.equals(this.dueDate, task.dueDate) && Objects.equals(this.processDefinitionId, task.processDefinitionId) && Objects.equals(this.processInstanceId, task.processInstanceId) && Objects.equals(this.parentTaskId, task.parentTaskId) && Objects.equals(this.formKey, task.formKey) && Objects.equals(this.processDefinitionVersion, task.processDefinitionVersion) && Objects.equals(this.businessKey, task.businessKey) && this.status == task.status;
    }
}

