/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.common.error.attributes;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.activiti.cloud.common.error.attributes.ErrorAttributesCustomizer;
import org.activiti.cloud.common.error.attributes.ErrorAttributesMessageSanitizer;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorMvcAutoConfiguration;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.DefaultErrorAttributes;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.web.context.request.WebRequest;

@AutoConfiguration
@AutoConfigureBefore(value={ErrorMvcAutoConfiguration.class})
public class ErrorAttributesAutoConfiguration {
    @Bean
    @Order(value=-2147483648)
    public ErrorAttributes errorAttributes(final List<ErrorAttributesCustomizer> errorAttributesCustomizers) {
        return new DefaultErrorAttributes(this){
            {
                Objects.requireNonNull(this$0);
            }

            public Map<String, Object> getErrorAttributes(WebRequest webRequest, ErrorAttributeOptions options) {
                Map<String, Object> errorAttributes = super.getErrorAttributes(webRequest, options);
                for (ErrorAttributesCustomizer customizer : errorAttributesCustomizers) {
                    errorAttributes = customizer.customize(errorAttributes, this.getError(webRequest));
                }
                return errorAttributes;
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean(name={"errorAttributesMessageSanitizer"})
    public ErrorAttributesCustomizer errorAttributesMessageSanitizer() {
        return new ErrorAttributesMessageSanitizer();
    }
}

