/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.common.messaging;

import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.Size;
import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Stream;
import org.activiti.cloud.common.messaging.config.InputConverterFunction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="activiti.cloud.messaging")
@Validated
public class ActivitiCloudMessagingProperties {
    public static final String ACTIVITI_CLOUD_MESSAGING_PREFIX = "activiti.cloud.messaging";
    @NotNull
    private MessagingBroker broker = MessagingBroker.rabbitmq;
    @NotNull
    private Boolean partitioned = false;
    @NotNull
    @Positive
    private Integer partitionCount = 1;
    @NotNull
    @Min(value=0L)
    private @NotNull @Min(value=0L) Integer instanceIndex = 0;
    @NotEmpty
    @Size(min=1, max=1)
    private @NotEmpty @Size(min=1, max=1) String destinationSeparator = "_";
    private String destinationPrefix = "";
    private boolean destinationTransformersEnabled = false;
    private List<String> destinationTransformers = new ArrayList<String>();
    private String destinationIllegalCharsRegex = "[\\t\\s*#:]";
    private String destinationIllegalCharsReplacement = "-";
    @NestedConfigurationProperty
    private FunctionRouterProperties functionRouter = new FunctionRouterProperties();
    private Map<String, DestinationProperties> destinations = new LinkedCaseInsensitiveMap();
    private Map<String, InputConverterFunction> inputConverters;
    private RabbitMqProperties rabbitmq = new RabbitMqProperties();

    public RabbitMqProperties getRabbitmq() {
        return this.rabbitmq;
    }

    public void setRabbitmq(RabbitMqProperties rabbitmq) {
        this.rabbitmq = rabbitmq;
    }

    public Boolean isPartitioned() {
        return this.partitioned;
    }

    public void setPartitioned(boolean partitioned) {
        this.partitioned = partitioned;
    }

    public Integer getPartitionCount() {
        return this.partitionCount;
    }

    public void setPartitionCount(Integer partitionCount) {
        this.partitionCount = partitionCount;
    }

    public Integer getInstanceIndex() {
        return this.instanceIndex;
    }

    public void setInstanceIndex(Integer instanceIndex) {
        this.instanceIndex = instanceIndex;
    }

    public String getDestinationSeparator() {
        return this.destinationSeparator;
    }

    public void setDestinationSeparator(String destinationSeparator) {
        this.destinationSeparator = destinationSeparator;
    }

    public String getDestinationPrefix() {
        return this.destinationPrefix;
    }

    public void setDestinationPrefix(String destinationPrefix) {
        this.destinationPrefix = destinationPrefix;
    }

    public Map<String, DestinationProperties> getDestinations() {
        return this.destinations;
    }

    public void setDestinations(Map<String, DestinationProperties> destinations) {
        this.destinations = destinations;
    }

    public boolean isDestinationTransformersEnabled() {
        return this.destinationTransformersEnabled;
    }

    public void setDestinationTransformersEnabled(boolean destinationTransformersEnabled) {
        this.destinationTransformersEnabled = destinationTransformersEnabled;
    }

    public String getDestinationIllegalCharsRegex() {
        return this.destinationIllegalCharsRegex;
    }

    public void setDestinationIllegalCharsRegex(String destinationIllegalCharsRegex) {
        this.destinationIllegalCharsRegex = destinationIllegalCharsRegex;
    }

    public String getDestinationIllegalCharsReplacement() {
        return this.destinationIllegalCharsReplacement;
    }

    public void setDestinationIllegalCharsReplacement(String destinationIllegalCharsReplacement) {
        this.destinationIllegalCharsReplacement = destinationIllegalCharsReplacement;
    }

    public FunctionRouterProperties getFunctionRouter() {
        return this.functionRouter;
    }

    public void setFunctionRouter(FunctionRouterProperties functionRouter) {
        this.functionRouter = functionRouter;
    }

    public Function<String, String> transformDestination() {
        return input -> {
            InputConverter<String> converter = new InputConverter<String>((String)input);
            for (String it : this.destinationTransformers) {
                InputConverterFunction func = Optional.ofNullable(this.inputConverters.get(it)).orElseThrow();
                converter = converter.convertBy(func);
            }
            return converter.pack();
        };
    }

    @Autowired
    public void configureInputConverters(@Lazy Map<String, InputConverterFunction> inputConverters) {
        this.inputConverters = new LinkedHashMap<String, InputConverterFunction>(inputConverters);
    }

    public List<String> getDestinationTransformers() {
        return this.destinationTransformers;
    }

    public void setDestinationTransformers(List<String> destinationTransformers) {
        this.destinationTransformers = destinationTransformers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivitiCloudMessagingProperties that = (ActivitiCloudMessagingProperties)o;
        return this.broker == that.broker && Objects.equals(this.partitioned, that.partitioned) && Objects.equals(this.partitionCount, that.partitionCount) && Objects.equals(this.instanceIndex, that.instanceIndex) && Objects.equals(this.destinationSeparator, that.destinationSeparator) && Objects.equals(this.destinationPrefix, that.destinationPrefix) && Objects.equals(this.destinations, that.destinations) && Objects.equals(this.functionRouter, that.functionRouter);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.broker, this.partitioned, this.partitionCount, this.instanceIndex, this.destinationSeparator, this.destinationPrefix, this.destinations});
    }

    public String toString() {
        return "ActivitiCloudMessagingProperties{broker=" + String.valueOf((Object)this.broker) + ", partitioned=" + this.partitioned + ", partitionCount=" + this.partitionCount + ", instanceIndex=" + this.instanceIndex + ", destinationSeparator='" + this.destinationSeparator + "', destinationPrefix='" + this.destinationPrefix + "', destinations=" + String.valueOf(this.destinations) + ", destinationIllegalCharsReplacement=" + this.destinationIllegalCharsReplacement + ", destinationIllegalCharsRegex=" + this.destinationIllegalCharsRegex + "}";
    }

    public static enum MessagingBroker {
        rabbitmq,
        kafka,
        aws;

    }

    @Validated
    public static class FunctionRouterProperties {
        private boolean enabled;
        private final Map<String, BindingFunctionRouterProperties> routes = new LinkedCaseInsensitiveMap();
        private final Map<String, Map<String, String>> destinations = new LinkedCaseInsensitiveMap();
        private final Map<String, Map<String, List<String>>> registrations = new LinkedCaseInsensitiveMap();
        @NotEmpty
        private String group = "function-router";
        private int maxRetries = 3;
        private Duration retryInterval = Duration.ofMillis(10L);
        @NestedConfigurationProperty
        private final FunctionRouterAnonymousProperties anonymous = new FunctionRouterAnonymousProperties();
        @NestedConfigurationProperty
        private ConsumerProperties consumer = new ConsumerProperties();

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public Map<String, String> destinations() {
            LinkedCaseInsensitiveMap result = new LinkedCaseInsensitiveMap();
            this.destinations.forEach((arg_0, arg_1) -> FunctionRouterProperties.lambda$destinations$0((Map)result, arg_0, arg_1));
            return result;
        }

        public Map<String, String> destinations(String routingContext) {
            return this.destinations.computeIfAbsent(routingContext, key -> new LinkedCaseInsensitiveMap());
        }

        public Map<String, List<String>> registrations() {
            LinkedCaseInsensitiveMap result = new LinkedCaseInsensitiveMap();
            this.registrations.values().forEach(arg_0 -> FunctionRouterProperties.lambda$registrations$4((Map)result, arg_0));
            return result;
        }

        public Map<String, List<String>> registrations(String routingContext) {
            return this.registrations.computeIfAbsent(routingContext, key -> new LinkedCaseInsensitiveMap());
        }

        public Map<String, BindingFunctionRouterProperties> getRoutes() {
            return this.routes;
        }

        public boolean isFunctionRoute(String bindingName) {
            return this.routes.containsKey(bindingName) && this.routes.get(bindingName).isEnabled();
        }

        public List<String> getFunctionRoutes() {
            return this.routes.keySet().stream().filter(this::isFunctionRoute).toList();
        }

        public String groupPrefix() {
            return this.group.concat(".");
        }

        public void setGroupPrefix(String group) {
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public ConsumerProperties getConsumer() {
            return this.consumer;
        }

        public void setConsumer(ConsumerProperties consumer) {
            this.consumer = consumer;
        }

        public boolean isExcludeRequiredProducerGroup(String bindingName) {
            return Optional.ofNullable(this.routes.get(bindingName)).map(BindingFunctionRouterProperties::isExcludeRequiredProducerGroups).orElse(false);
        }

        public boolean isOverrideRequiredProducerGroup(String bindingName) {
            return Optional.ofNullable(this.routes.get(bindingName)).map(BindingFunctionRouterProperties::getOverrideRequiredProducerGroups).map(it -> !it.isEmpty()).orElse(false);
        }

        public int getMaxRetries() {
            return this.maxRetries;
        }

        public void setMaxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
        }

        public Duration getRetryInterval() {
            return this.retryInterval;
        }

        public void setRetryInterval(Duration retryInterval) {
            this.retryInterval = retryInterval;
        }

        public void register(String bindingName, String functionBeanName) {
            this.destinations.keySet().forEach(routingContext -> Optional.ofNullable(this.destinations.get(routingContext)).map(it -> (String)it.get(bindingName)).ifPresent(destination -> this.registrations((String)routingContext).computeIfAbsent((String)destination, key -> new ArrayList()).add(functionBeanName)));
        }

        public boolean equals(Object o) {
            if (!(o instanceof FunctionRouterProperties)) {
                return false;
            }
            FunctionRouterProperties that = (FunctionRouterProperties)o;
            return this.enabled == that.enabled && this.maxRetries == that.maxRetries && Objects.equals(this.routes, that.routes) && Objects.equals(this.destinations, that.destinations) && Objects.equals(this.registrations, that.registrations) && Objects.equals(this.group, that.group) && Objects.equals(this.retryInterval, that.retryInterval) && Objects.equals(this.consumer, that.consumer) && Objects.equals(this.anonymous, that.anonymous);
        }

        public int hashCode() {
            return Objects.hash(this.enabled, this.routes, this.destinations, this.registrations, this.group, this.maxRetries, this.retryInterval, this.consumer, this.anonymous);
        }

        public String toString() {
            return new StringJoiner(", ", FunctionRouterProperties.class.getSimpleName() + "[", "]").add("enabled=" + this.enabled).add("routes=" + String.valueOf(this.routes)).add("destinations=" + String.valueOf(this.destinations)).add("registrations=" + String.valueOf(this.registrations)).add("group='" + this.group + "'").add("maxRetries=" + this.maxRetries).add("retryInterval=" + String.valueOf(this.retryInterval)).add("consumer=" + String.valueOf(this.consumer)).add("anonymous=" + String.valueOf(this.anonymous)).toString();
        }

        public FunctionRouterAnonymousProperties getAnonymous() {
            return this.anonymous;
        }

        private static /* synthetic */ void lambda$registrations$4(Map result, Map it) {
            it.forEach((key, value) -> result.compute(key, (k, v) -> v == null ? value : Stream.concat(v.stream(), value.stream()).distinct().toList()));
        }

        private static /* synthetic */ void lambda$destinations$0(Map result, String key, Map value) {
            result.putAll(value);
        }
    }

    public static class RabbitMqProperties {
        private Boolean missingAnonymousQueuesFatal;
        private Boolean missingDurableQueuesFatal;

        public Boolean getMissingAnonymousQueuesFatal() {
            return this.missingAnonymousQueuesFatal;
        }

        public void setMissingAnonymousQueuesFatal(Boolean missingAnonymousQueuesFatal) {
            this.missingAnonymousQueuesFatal = missingAnonymousQueuesFatal;
        }

        public Boolean getMissingDurableQueuesFatal() {
            return this.missingDurableQueuesFatal;
        }

        public void setMissingDurableQueuesFatal(Boolean missingDurableQueuesFatal) {
            this.missingDurableQueuesFatal = missingDurableQueuesFatal;
        }
    }

    static class InputConverter<T> {
        private final T data;

        public InputConverter(T data) {
            this.data = data;
        }

        public <U> InputConverter<U> convertBy(Function<T, U> function) {
            return new InputConverter<U>(function.apply(this.data));
        }

        public T pack() {
            return this.data;
        }
    }

    public static class FunctionRouterAnonymousProperties {
        @NestedConfigurationProperty
        private final ConsumerProperties consumer = new ConsumerProperties();

        public ConsumerProperties getConsumer() {
            return this.consumer;
        }

        public boolean equals(Object o) {
            if (!(o instanceof FunctionRouterAnonymousProperties)) {
                return false;
            }
            FunctionRouterAnonymousProperties that = (FunctionRouterAnonymousProperties)o;
            return Objects.equals(this.consumer, that.consumer);
        }

        public int hashCode() {
            return Objects.hash(this.consumer);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("FunctionRouterAnonymousProperties{");
            sb.append("consumer=").append(this.consumer);
            sb.append('}');
            return sb.toString();
        }
    }

    public static class BindingFunctionRouterProperties {
        private boolean enabled;
        private boolean excludeRequiredProducerGroups = true;
        private List<String> overrideRequiredProducerGroups = new ArrayList<String>();

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isExcludeRequiredProducerGroups() {
            return this.excludeRequiredProducerGroups;
        }

        public void setExcludeRequiredProducerGroups(boolean excludeRequiredProducerGroups) {
            this.excludeRequiredProducerGroups = excludeRequiredProducerGroups;
        }

        public List<String> getOverrideRequiredProducerGroups() {
            return this.overrideRequiredProducerGroups;
        }

        public void setOverrideRequiredProducerGroups(List<String> overrideRequiredProducerGroups) {
            this.overrideRequiredProducerGroups = overrideRequiredProducerGroups;
        }

        public String toString() {
            return new StringJoiner(", ", BindingFunctionRouterProperties.class.getSimpleName() + "[", "]").add("enabled=" + this.enabled).add("excludeRequiredProducerGroups=" + this.excludeRequiredProducerGroups).add("overrideRequiredProducerGroups=" + String.valueOf(this.overrideRequiredProducerGroups)).toString();
        }
    }

    @Validated
    public static class DestinationProperties {
        private String name = "";
        private String scope;
        private String prefix;
        private String separator;

        DestinationProperties() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getSeparator() {
            return this.separator;
        }

        public void setSeparator(String separator) {
            this.separator = separator;
        }

        public String getScope() {
            return this.scope;
        }

        public void setScope(String scope) {
            this.scope = scope;
        }

        public String toString() {
            return new StringJoiner(", ", DestinationProperties.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("scope='" + this.scope + "'").add("prefix='" + this.prefix + "'").add("separator='" + this.separator + "'").toString();
        }
    }
}

