/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.common.messaging.config;

import org.activiti.cloud.common.messaging.ActivitiCloudMessagingProperties;
import org.activiti.cloud.common.messaging.config.ActivitiCloudMessagingAutoConfiguration;
import org.activiti.cloud.common.messaging.config.ActivitiMessagingDestinationTransformer;
import org.activiti.cloud.common.messaging.config.ActivitiMessagingDestinationsBeanPostProcessor;
import org.activiti.cloud.common.messaging.config.FunctionBindingPropertySource;
import org.activiti.cloud.common.messaging.config.InputConverterFunction;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.stream.config.BinderFactoryAutoConfiguration;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.cloud.stream.function.StreamFunctionConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;

@AutoConfiguration
@AutoConfigureAfter(value={ActivitiCloudMessagingAutoConfiguration.class})
@AutoConfigureBefore(value={BinderFactoryAutoConfiguration.class})
@ConditionalOnClass(value={BindingServiceProperties.class})
public class ActivitiMessagingDestinationsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ActivitiMessagingDestinationTransformer activitiMessagingDestinationTransformer(ActivitiCloudMessagingProperties messagingProperties) {
        return new ActivitiMessagingDestinationTransformer(messagingProperties);
    }

    @Bean
    public ActivitiMessagingDestinationsBeanPostProcessor activitiMessagingDestinationsBeanPostProcessor(ActivitiMessagingDestinationTransformer destinationTransformer, ActivitiCloudMessagingProperties messagingProperties, FunctionBindingPropertySource functionBindingPropertySource, StreamFunctionConfigurationProperties streamFunctionProperties) {
        return new ActivitiMessagingDestinationsBeanPostProcessor(destinationTransformer, messagingProperties, functionBindingPropertySource, streamFunctionProperties);
    }

    @Bean
    public InputConverterFunction toLowerCase() {
        return String::toLowerCase;
    }

    @Bean
    public InputConverterFunction escapeIllegalChars(@Lazy ActivitiCloudMessagingProperties messagingProperties) {
        return value -> value.replaceAll(messagingProperties.getDestinationIllegalCharsRegex(), messagingProperties.getDestinationIllegalCharsReplacement());
    }
}

