/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.common.messaging.config;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.activiti.cloud.common.messaging.config.AbstractFunctionalBindingConfiguration;
import org.activiti.cloud.common.messaging.config.FunctionAnnotationService;
import org.activiti.cloud.common.messaging.functional.OutputBinding;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.cloud.stream.binder.JavaClassMimeTypeUtils;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.binding.DefaultPartitioningInterceptor;
import org.springframework.cloud.stream.config.BinderFactoryAutoConfiguration;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.cloud.stream.converter.MessageConverterUtils;
import org.springframework.cloud.stream.function.FunctionConfiguration;
import org.springframework.cloud.stream.function.StreamFunctionProperties;
import org.springframework.cloud.stream.messaging.DirectWithAttributesChannel;
import org.springframework.context.annotation.Bean;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.messaging.support.InterceptableChannel;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.MimeType;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@AutoConfiguration(after={BinderFactoryAutoConfiguration.class}, before={FunctionConfiguration.class})
public class OutputBindingConfiguration
extends AbstractFunctionalBindingConfiguration {
    public static final String OUTPUT_BINDING = "_source";

    @Bean
    public BeanPostProcessor outputBindingBeanPostProcessor(final FunctionAnnotationService functionAnnotationService, final BindingServiceProperties bindingServiceProperties, final StreamFunctionProperties streamFunctionProperties, final DefaultListableBeanFactory beanFactory) {
        return new BeanPostProcessor(){
            final /* synthetic */ OutputBindingConfiguration this$0;
            {
                OutputBindingConfiguration outputBindingConfiguration = this$0;
                Objects.requireNonNull(outputBindingConfiguration);
                this.this$0 = outputBindingConfiguration;
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (MessageChannel.class.isInstance(bean)) {
                    Optional.ofNullable(functionAnnotationService.findAnnotationOnBean(beanName, OutputBinding.class)).ifPresent(functionBinding -> {
                        String beanOutName = AbstractFunctionalBindingConfiguration.getOutBinding(beanName + OutputBindingConfiguration.OUTPUT_BINDING);
                        Object outputBindings = bindingServiceProperties.getOutputBindings();
                        outputBindings = !StringUtils.hasText((String)outputBindings) ? beanOutName : (String)outputBindings + ";" + beanOutName;
                        bindingServiceProperties.setOutputBindings((String)outputBindings);
                        streamFunctionProperties.getBindings().put(beanOutName, beanName);
                        if (!DirectWithAttributesChannel.class.isInstance(bean)) {
                            this.this$0.getMessageConverterConfigurer().configureOutputChannel((MessageChannel)MessageChannel.class.cast(bean), beanName);
                        }
                        CompositeMessageConverter messageConverter = this.this$0.getMessageConverter();
                        BindingProperties bindingProperties = bindingServiceProperties.getBindingProperties(beanName);
                        Optional.ofNullable(bindingProperties.getProducer()).filter(ProducerProperties::isPartitioned).ifPresent(isPartitioned -> ((InterceptableChannel)InterceptableChannel.class.cast(bean)).addInterceptor((ChannelInterceptor)new DefaultPartitioningInterceptor(bindingProperties, (ConfigurableListableBeanFactory)beanFactory)));
                        ((InterceptableChannel)InterceptableChannel.class.cast(bean)).addInterceptor((ChannelInterceptor)new OutboundContentTypeConvertingInterceptor(this.this$0, "application/json", messageConverter));
                    });
                }
                return bean;
            }
        };
    }

    private final class OutboundContentTypeConvertingInterceptor
    implements ChannelInterceptor {
        final MimeType mimeType;
        private final MessageConverter messageConverter;

        private OutboundContentTypeConvertingInterceptor(OutputBindingConfiguration outputBindingConfiguration, String contentType, CompositeMessageConverter messageConverter) {
            Objects.requireNonNull(outputBindingConfiguration);
            this.mimeType = MessageConverterUtils.getMimeType((String)contentType);
            this.messageConverter = messageConverter;
        }

        public Message<?> preSend(Message<?> message, MessageChannel channel) {
            if (message instanceof ErrorMessage || this.isByteArrayWithContentType(message)) {
                return message;
            }
            String contentTypeFromHeader = message.getHeaders().containsKey((Object)"contentType") ? message.getHeaders().get((Object)"contentType").toString() : null;
            String contentTypeFromPayload = message.getPayload() instanceof String ? JavaClassMimeTypeUtils.mimeTypeFromObject((Object)message.getPayload(), (String)ObjectUtils.nullSafeToString((Object)contentTypeFromHeader)).toString() : contentTypeFromHeader;
            MessageHeaders messageHeaders = this.getMessageHeaders(message);
            Message<byte[]> outboundMessage = this.getOutboundMessage(message, messageHeaders);
            MessageHeaders outboundMessageHeaders = this.getOutboundMessageHeaders(outboundMessage, contentTypeFromPayload, contentTypeFromHeader);
            return MessageBuilder.fromMessage(outboundMessage).copyHeaders((Map)outboundMessageHeaders).build();
        }

        private boolean isByteArrayWithContentType(Message<?> message) {
            return message.getPayload() instanceof byte[] && message.getHeaders().containsKey((Object)"contentType");
        }

        private MessageHeaders getMessageHeaders(Message<?> message) {
            MessageHeaders messageHeaders = message.getHeaders();
            if (!message.getHeaders().containsKey((Object)"contentType")) {
                MessageHeaderAccessor accessor = MessageHeaderAccessor.getMutableAccessor(message);
                accessor.setContentType(this.mimeType);
                messageHeaders = accessor.toMessageHeaders();
            }
            return messageHeaders;
        }

        private MessageHeaders getOutboundMessageHeaders(Message<?> outboundMessage, String contentTypeFromPayload, String contentTypeFromHeader) {
            MessageHeaders outboundMessageHeaders = outboundMessage.getHeaders();
            if (contentTypeFromPayload != null && !contentTypeFromPayload.equals(contentTypeFromHeader) && contentTypeFromHeader != null) {
                MessageHeaderAccessor accessor = MessageHeaderAccessor.getMutableAccessor(outboundMessage);
                accessor.setContentType(MimeType.valueOf((String)contentTypeFromPayload));
                outboundMessageHeaders = accessor.toMessageHeaders();
            }
            return outboundMessageHeaders;
        }

        private Message<byte[]> getOutboundMessage(Message<?> message, MessageHeaders messageHeaders) {
            Message outboundMessage;
            Message message2 = outboundMessage = message.getPayload() instanceof byte[] ? message : this.messageConverter.toMessage(message.getPayload(), messageHeaders);
            if (outboundMessage == null) {
                throw new IllegalStateException("Failed to convert message: '" + String.valueOf(message) + "' to outbound message.");
            }
            return outboundMessage;
        }
    }
}

