/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.common.messaging.config;

import java.util.Objects;
import java.util.Optional;
import org.activiti.cloud.common.messaging.ActivitiCloudMessagingProperties;
import org.activiti.cloud.common.messaging.config.AbstractFunctionalBindingConfiguration;
import org.activiti.cloud.common.messaging.config.FunctionAnnotationService;
import org.activiti.cloud.common.messaging.functional.InputBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.cloud.stream.config.BinderFactoryAutoConfiguration;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.cloud.stream.function.FunctionConfiguration;
import org.springframework.cloud.stream.function.StreamFunctionProperties;
import org.springframework.cloud.stream.messaging.DirectWithAttributesChannel;
import org.springframework.context.annotation.Bean;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.StringUtils;

@AutoConfiguration(after={BinderFactoryAutoConfiguration.class}, before={FunctionConfiguration.class})
public class InputBindingConfiguration
extends AbstractFunctionalBindingConfiguration {
    public static final String INPUT_BINDING = "_sink";
    private static final Logger log = LoggerFactory.getLogger(InputBindingConfiguration.class);

    @Bean
    public BeanPostProcessor inputBindingBeanPostProcessor(final FunctionAnnotationService functionAnnotationService, final BindingServiceProperties bindingServiceProperties, final StreamFunctionProperties streamFunctionProperties, final ActivitiCloudMessagingProperties messagingProperties) {
        return new BeanPostProcessor(){
            final /* synthetic */ InputBindingConfiguration this$0;
            {
                InputBindingConfiguration inputBindingConfiguration = this$0;
                Objects.requireNonNull(inputBindingConfiguration);
                this.this$0 = inputBindingConfiguration;
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (MessageChannel.class.isInstance(bean)) {
                    ActivitiCloudMessagingProperties.FunctionRouterProperties functionRouter = messagingProperties.getFunctionRouter();
                    Optional.ofNullable(functionAnnotationService.findAnnotationOnBean(beanName, InputBinding.class)).filter(inputBinding -> {
                        boolean hasBindingConfiguration = bindingServiceProperties.getBindings().containsKey(inputBinding.value()[0]);
                        if (!hasBindingConfiguration) {
                            log.warn("Skipping input binding {} configuration due to missing binding service properties", (Object)inputBinding.value()[0]);
                        }
                        return hasBindingConfiguration;
                    }).ifPresent(inputBinding -> {
                        String beanInName = AbstractFunctionalBindingConfiguration.getInBinding(beanName + InputBindingConfiguration.INPUT_BINDING);
                        Object inputBindings = bindingServiceProperties.getInputBindings();
                        inputBindings = !StringUtils.hasText((String)inputBindings) ? beanInName : (String)inputBindings + ";" + beanInName;
                        bindingServiceProperties.setInputBindings((String)inputBindings);
                        streamFunctionProperties.getBindings().put(beanInName, beanName);
                        if (!DirectWithAttributesChannel.class.isInstance(bean)) {
                            this.this$0.getMessageConverterConfigurer().configureInputChannel((MessageChannel)MessageChannel.class.cast(bean), beanName);
                        }
                    });
                }
                return bean;
            }
        };
    }
}

