/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.microsoft.bot.builder.BotFrameworkAdapter;
import com.microsoft.bot.connector.authentication.AppCredentials;
import com.microsoft.bot.connector.authentication.AuthenticationConfiguration;
import com.microsoft.bot.connector.authentication.MicrosoftAppCredentials;
import com.microsoft.bot.schema.Activity;
import com.microsoft.bot.schema.Attachment;
import com.microsoft.bot.schema.ChannelAccount;
import com.microsoft.bot.schema.ConversationParameters;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class TeamsChatService {
    private final String appId;
    private final String appTenant;
    private final BotFrameworkAdapter adapter;
    private final MicrosoftAppCredentials appCredentials;

    public TeamsChatService(String appId, String appPassword, String appTenant) {
        this.appId = appId;
        this.appTenant = appTenant;
        this.appCredentials = new MicrosoftAppCredentials(appId, appPassword, appTenant);
        AuthenticationConfiguration authConfig = new AuthenticationConfiguration();
        this.adapter = new BotFrameworkAdapter((AppCredentials)this.appCredentials, authConfig, null, null, null);
        this.adapter.setOnTurnError((turnContext, exception) -> {
            System.err.println("Exception raised bot: " + exception.getMessage());
            exception.printStackTrace();
            return turnContext.sendActivity("We have a problem!!!").thenApply(result -> null);
        });
    }

    public CompletableFuture<Void> sendSimpleMessage(String teamsUserId, String message) {
        System.out.println("========== SENDING MESSAGE ==========");
        System.out.println("Teams User ID: " + teamsUserId);
        System.out.println("Message: " + message);
        System.out.println("Bot App ID: " + this.appId);
        System.out.println("Tenant ID: " + this.appTenant);
        System.out.println("================================================");
        ConversationParameters conversationParams = new ConversationParameters();
        ChannelAccount user = new ChannelAccount();
        user.setId(teamsUserId);
        conversationParams.setMembers(Collections.singletonList(user));
        ChannelAccount bot = new ChannelAccount();
        bot.setId(this.appId);
        conversationParams.setBot(bot);
        conversationParams.setTenantId(this.appTenant);
        return this.adapter.createConversation("msteams", "https://smba.trafficmanager.net/amer/", this.appCredentials, conversationParams, turnContext -> {
            System.out.println("Conversation Created!");
            System.out.println("Conversation ID: " + turnContext.getActivity().getConversation().getId());
            return turnContext.sendActivity(message).thenApply(result -> {
                System.out.println("Message sent!");
                System.out.println("Activity ID: " + result.getId());
                return null;
            });
        }).exceptionally(throwable -> {
            System.err.println("========== ERROR ==========");
            System.err.println("Type: " + throwable.getClass().getName());
            System.err.println("Message: " + throwable.getMessage());
            Throwable cause = throwable.getCause();
            if (cause != null) {
                System.err.println("Cause: " + cause.getClass().getName());
                System.err.println("Error Message: " + cause.getMessage());
            }
            System.err.println("Error:");
            throwable.printStackTrace();
            System.err.println("================================");
            return null;
        });
    }

    public CompletableFuture<Void> sendAdaptiveCard(String teamsUserId, String title, String description, Map<String, String> data, String jsonDetail) {
        System.out.println("========== SENDING ADAPTIVE CARD ==========");
        System.out.println("Teams User ID: " + teamsUserId);
        System.out.println("Card Title: " + title);
        System.out.println("Bot App ID: " + this.appId);
        System.out.println("Tenant ID: " + this.appTenant);
        System.out.println("================================================");
        ConversationParameters conversationParams = new ConversationParameters();
        ChannelAccount user = new ChannelAccount();
        user.setId(teamsUserId);
        conversationParams.setMembers(Collections.singletonList(user));
        ChannelAccount bot = new ChannelAccount();
        bot.setId(this.appId);
        conversationParams.setBot(bot);
        conversationParams.setTenantId(this.appTenant);
        return this.adapter.createConversation("msteams", "https://smba.trafficmanager.net/amer/", this.appCredentials, conversationParams, turnContext -> {
            System.out.println("Conversation Created!");
            System.out.println("Conversation ID: " + turnContext.getActivity().getConversation().getId());
            Attachment cardAttachment = this.createComplexAdaptiveCard(title, description, data, jsonDetail);
            Activity reply = Activity.createMessageActivity();
            reply.setAttachments(Collections.singletonList(cardAttachment));
            return turnContext.sendActivity(reply).thenApply(result -> {
                System.out.println("Adaptive Card sent!");
                System.out.println("Activity ID: " + result.getId());
                return null;
            });
        }).exceptionally(throwable -> {
            System.err.println("========== ERROR ==========");
            System.err.println("Type: " + throwable.getClass().getName());
            System.err.println("Message: " + throwable.getMessage());
            Throwable cause = throwable.getCause();
            if (cause != null) {
                System.err.println("Cause: " + cause.getClass().getName());
                System.err.println("Error Message: " + cause.getMessage());
            }
            System.err.println("Error:");
            throwable.printStackTrace();
            System.err.println("================================");
            return null;
        });
    }

    private Attachment createComplexAdaptiveCard(String title, String description, Map<String, String> data, String jsonDetails) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode cardContent = mapper.createObjectNode();
        cardContent.put("$schema", "http://adaptivecards.io/schemas/adaptive-card.json");
        cardContent.put("type", "AdaptiveCard");
        cardContent.put("version", "1.5");
        ArrayNode body = mapper.createArrayNode();
        ObjectNode mainContainer = mapper.createObjectNode();
        mainContainer.put("type", "Container");
        mainContainer.put("width", "stretch");
        ArrayNode containerItems = mapper.createArrayNode();
        ObjectNode headerContainer = mapper.createObjectNode();
        headerContainer.put("type", "Container");
        headerContainer.put("style", "emphasis");
        headerContainer.put("width", "stretch");
        ArrayNode headerItems = mapper.createArrayNode();
        ObjectNode titleBlock = mapper.createObjectNode();
        titleBlock.put("type", "TextBlock");
        titleBlock.put("text", title);
        titleBlock.put("size", "Large");
        titleBlock.put("weight", "Bolder");
        titleBlock.put("color", "Accent");
        titleBlock.put("wrap", true);
        headerItems.add((JsonNode)titleBlock);
        headerContainer.set("items", (JsonNode)headerItems);
        containerItems.add((JsonNode)headerContainer);
        ObjectNode descriptionBlock = mapper.createObjectNode();
        descriptionBlock.put("type", "TextBlock");
        descriptionBlock.put("text", description);
        descriptionBlock.put("wrap", true);
        descriptionBlock.put("spacing", "Medium");
        containerItems.add((JsonNode)descriptionBlock);
        ObjectNode separator1 = mapper.createObjectNode();
        separator1.put("type", "Container");
        separator1.put("separator", true);
        separator1.put("spacing", "Medium");
        containerItems.add((JsonNode)separator1);
        if (data != null && !data.isEmpty()) {
            ObjectNode dataContainer = mapper.createObjectNode();
            dataContainer.put("type", "Container");
            dataContainer.put("spacing", "Medium");
            ArrayNode dataItems = mapper.createArrayNode();
            for (Map.Entry<String, String> entry : data.entrySet()) {
                ObjectNode labelBlock = mapper.createObjectNode();
                labelBlock.put("type", "TextBlock");
                labelBlock.put("text", entry.getKey() + ":");
                labelBlock.put("weight", "Bolder");
                labelBlock.put("spacing", "Small");
                labelBlock.put("wrap", true);
                dataItems.add((JsonNode)labelBlock);
                ObjectNode valueBlock = mapper.createObjectNode();
                valueBlock.put("type", "TextBlock");
                valueBlock.put("text", entry.getValue());
                valueBlock.put("wrap", true);
                valueBlock.put("spacing", "None");
                valueBlock.put("color", "Default");
                dataItems.add((JsonNode)valueBlock);
            }
            dataContainer.set("items", (JsonNode)dataItems);
            containerItems.add((JsonNode)dataContainer);
        }
        ObjectNode separator2 = mapper.createObjectNode();
        separator2.put("type", "Container");
        separator2.put("separator", true);
        separator2.put("spacing", "Medium");
        containerItems.add((JsonNode)separator2);
        ObjectNode jsonContainer = mapper.createObjectNode();
        jsonContainer.put("type", "Container");
        jsonContainer.put("id", "jsonDetailsContainer");
        jsonContainer.put("isVisible", false);
        jsonContainer.put("spacing", "Medium");
        jsonContainer.put("width", "stretch");
        ArrayNode jsonItems = mapper.createArrayNode();
        ObjectNode jsonTitle = mapper.createObjectNode();
        jsonTitle.put("type", "TextBlock");
        jsonTitle.put("text", "\ud83d\udccb Details");
        jsonTitle.put("weight", "Bolder");
        jsonTitle.put("size", "Medium");
        jsonTitle.put("spacing", "Small");
        jsonItems.add((JsonNode)jsonTitle);
        ObjectNode jsonBlock = mapper.createObjectNode();
        jsonBlock.put("type", "TextBlock");
        String formattedJson = this.formatJsonForDisplay(jsonDetails);
        jsonBlock.put("text", "```json\n" + formattedJson + "\n```");
        jsonBlock.put("wrap", true);
        jsonBlock.put("fontType", "Monospace");
        jsonBlock.put("spacing", "Small");
        jsonBlock.put("maxLines", 0);
        jsonItems.add((JsonNode)jsonBlock);
        jsonContainer.set("items", (JsonNode)jsonItems);
        containerItems.add((JsonNode)jsonContainer);
        mainContainer.set("items", (JsonNode)containerItems);
        body.add((JsonNode)mainContainer);
        cardContent.set("body", (JsonNode)body);
        ArrayNode actions = mapper.createArrayNode();
        ObjectNode toggleAction = mapper.createObjectNode();
        toggleAction.put("type", "Action.ToggleVisibility");
        toggleAction.put("title", "\ud83d\udd0d Event Details");
        ArrayNode targetElements = mapper.createArrayNode();
        ObjectNode target = mapper.createObjectNode();
        target.put("elementId", "jsonDetailsContainer");
        targetElements.add((JsonNode)target);
        toggleAction.set("targetElements", (JsonNode)targetElements);
        actions.add((JsonNode)toggleAction);
        ObjectNode openUrlAction = mapper.createObjectNode();
        openUrlAction.put("type", "Action.OpenUrl");
        openUrlAction.put("title", "\ud83c\udf10 Open in Studio Admin");
        openUrlAction.put("url", "https://hxps-alpha.studio.dev.experience.hyland.com/admin/#/processadmin/audit");
        actions.add((JsonNode)openUrlAction);
        cardContent.set("actions", (JsonNode)actions);
        Attachment attachment = new Attachment();
        attachment.setContentType("application/vnd.microsoft.card.adaptive");
        attachment.setContent((Object)cardContent);
        return attachment;
    }

    private String formatJsonForDisplay(String jsonString) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            Object json = mapper.readValue(jsonString, Object.class);
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(json);
        }
        catch (Exception e) {
            return jsonString;
        }
    }
}

