/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.streams.config;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.common.messaging.functional.FunctionBinding;
import org.activiti.cloud.services.audit.api.converters.APIEventToEntityConverters;
import org.activiti.cloud.services.audit.api.streams.AuditConsumerChannelHandler;
import org.activiti.cloud.services.audit.jpa.repository.EventsRepository;
import org.activiti.cloud.services.audit.jpa.streams.AuditConsumerChannelHandlerImpl;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.messaging.Message;

@AutoConfiguration
public class AuditJPAStreamsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public AuditConsumerChannelHandler auditConsumerChannelHandler(EventsRepository eventsRepository, APIEventToEntityConverters eventConverters) {
        return new AuditConsumerChannelHandlerImpl(eventsRepository, eventConverters);
    }

    @FunctionBinding(input="auditConsumer")
    @Bean
    public Consumer<Message<List<CloudRuntimeEvent<?, ?>>>> auditConsumerChannelHandlerConsumer(AuditConsumerChannelHandler handler) {
        return message -> handler.receiveCloudRuntimeEvent((Map<String, Object>)message.getHeaders(), Optional.ofNullable((List)message.getPayload()).orElse(Collections.emptyList()).toArray(new CloudRuntimeEvent[0]));
    }
}

