/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.converters.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.persistence.AttributeConverter;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.activiti.cloud.services.audit.api.AuditException;

public class ListOfStackTraceElementsJpaJsonConverter
implements AttributeConverter<List<StackTraceElement>, String> {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public String convertToDatabaseColumn(List<StackTraceElement> entity) {
        try {
            return objectMapper.writeValueAsString(entity);
        }
        catch (JsonProcessingException e) {
            throw new AuditException("Unable to serialize object.", e);
        }
    }

    public List<StackTraceElement> convertToEntityAttribute(String entityTextRepresentation) {
        try {
            if (entityTextRepresentation != null && entityTextRepresentation.length() > 0) {
                return (List)objectMapper.readValue(entityTextRepresentation, (TypeReference)new TypeReference<List<StackTraceElement>>(this){
                    {
                        Objects.requireNonNull(this$0);
                    }
                });
            }
            return Collections.emptyList();
        }
        catch (IOException e) {
            throw new AuditException("Unable to deserialize object.", e);
        }
    }
}

