/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.events;

import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import org.activiti.api.process.model.ProcessDefinition;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.process.model.events.CloudProcessDeployedEvent;
import org.activiti.cloud.services.audit.jpa.converters.json.ProcessDefinitionJpaJsonConverter;
import org.activiti.cloud.services.audit.jpa.events.AuditEventEntity;

@Entity(name="ProcessDeployedEvent")
@DiscriminatorValue(value="ProcessDeployedEvent")
public class ProcessDeployedAuditEventEntity
extends AuditEventEntity {
    protected static final String PROCESS_DEPLOYED_EVENT = "ProcessDeployedEvent";
    @Convert(converter=ProcessDefinitionJpaJsonConverter.class)
    @Column(columnDefinition="text")
    private ProcessDefinition processDefinition;

    public ProcessDeployedAuditEventEntity() {
    }

    public ProcessDeployedAuditEventEntity(CloudProcessDeployedEvent cloudEvent) {
        super((CloudRuntimeEvent<?, ?>)cloudEvent);
        this.setProcessDefinition((ProcessDefinition)cloudEvent.getEntity());
    }

    public ProcessDefinition getProcessDefinition() {
        return this.processDefinition;
    }

    public void setProcessDefinition(ProcessDefinition processDefinition) {
        this.processDefinition = processDefinition;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ProcessDeployedAuditEventEntity [processDefinition=").append(this.processDefinition).append(", toString()=").append(super.toString()).append("]");
        return builder.toString();
    }
}

