/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.repository;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import org.activiti.cloud.services.audit.jpa.events.AuditEventEntity;
import org.activiti.cloud.services.audit.jpa.repository.SearchOperation;
import org.activiti.cloud.services.audit.jpa.repository.SpecSearchCriteria;
import org.springframework.data.jpa.domain.Specification;

public class EventSpecification
implements Specification<AuditEventEntity> {
    private SpecSearchCriteria criteria;

    public EventSpecification(SpecSearchCriteria criteria) {
        this.criteria = criteria;
    }

    public SpecSearchCriteria getCriteria() {
        return this.criteria;
    }

    public Predicate toPredicate(Root<AuditEventEntity> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
        return switch (this.criteria.getOperation()) {
            case SearchOperation.EQUALITY -> builder.equal((Expression)root.get(this.criteria.getKey()), this.criteria.getValue());
            case SearchOperation.NEGATION -> builder.notEqual((Expression)root.get(this.criteria.getKey()), this.criteria.getValue());
            case SearchOperation.GREATER_THAN -> builder.greaterThan((Expression)root.get(this.criteria.getKey()), (Comparable)((Object)this.criteria.getValue().toString()));
            case SearchOperation.GREATER_THAN_EQUAL -> builder.greaterThanOrEqualTo((Expression)root.get(this.criteria.getKey()), (Comparable)((Object)this.criteria.getValue().toString()));
            case SearchOperation.LESS_THAN -> builder.lessThan((Expression)root.get(this.criteria.getKey()), (Comparable)((Object)this.criteria.getValue().toString()));
            case SearchOperation.LESS_THAN_EQUAL -> builder.lessThanOrEqualTo((Expression)root.get(this.criteria.getKey()), (Comparable)((Object)this.criteria.getValue().toString()));
            case SearchOperation.LIKE -> builder.like((Expression)root.get(this.criteria.getKey()), this.criteria.getValue().toString());
            case SearchOperation.STARTS_WITH -> builder.like((Expression)root.get(this.criteria.getKey()), String.valueOf(this.criteria.getValue()) + "%");
            case SearchOperation.ENDS_WITH -> builder.like((Expression)root.get(this.criteria.getKey()), "%" + String.valueOf(this.criteria.getValue()));
            case SearchOperation.CONTAINS -> builder.like((Expression)root.get(this.criteria.getKey()), "%" + String.valueOf(this.criteria.getValue()) + "%");
            default -> null;
        };
    }
}

