/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.identity.keycloak;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.activiti.api.runtime.shared.identity.UserGroupManager;
import org.activiti.cloud.services.identity.keycloak.client.KeycloakClient;
import org.activiti.cloud.services.identity.keycloak.model.KeycloakGroup;
import org.activiti.cloud.services.identity.keycloak.model.KeycloakRoleMapping;
import org.activiti.cloud.services.identity.keycloak.model.KeycloakUser;

public class KeycloakUserGroupManager
implements UserGroupManager {
    private final KeycloakClient keycloakClient;

    public KeycloakUserGroupManager(KeycloakClient keycloakClient) {
        this.keycloakClient = keycloakClient;
    }

    public List<String> getUserGroups(String username) {
        KeycloakUser user = this.loadRepresentation(username);
        List<KeycloakGroup> groupRepresentations = this.keycloakClient.getUserGroups(user.getId());
        ArrayList<String> groups = null;
        if (groupRepresentations != null && groupRepresentations.size() > 0) {
            groups = new ArrayList<String>();
            for (KeycloakGroup groupRepresentation : groupRepresentations) {
                groups.add(groupRepresentation.getName());
            }
        }
        return groups;
    }

    public List<String> getUserRoles(String username) {
        KeycloakUser user = this.loadRepresentation(username);
        List<KeycloakRoleMapping> rolesRepresentations = this.keycloakClient.getUserRoleMapping(user.getId());
        ArrayList<String> roles = null;
        if (rolesRepresentations != null && rolesRepresentations.size() > 0) {
            roles = new ArrayList<String>();
            for (KeycloakRoleMapping roleRepresentation : rolesRepresentations) {
                roles.add(roleRepresentation.getName());
            }
        }
        return roles;
    }

    public List<String> getGroups() {
        return this.keycloakClient.getAllGroups().stream().map(KeycloakGroup::getName).collect(Collectors.toList());
    }

    public List<String> getUsers() {
        return this.keycloakClient.getAllUsers(this.keycloakClient.countAllUsers()).stream().map(KeycloakUser::getUsername).collect(Collectors.toList());
    }

    private KeycloakUser loadRepresentation(String username) {
        List<KeycloakUser> users = this.keycloakClient.searchUsers(username, 0, 2);
        if (users.size() > 1) {
            throw new UnsupportedOperationException("User id " + username + " is not unique");
        }
        if (users.size() == 0) {
            throw new UnsupportedOperationException("User id " + username + " not found");
        }
        return users.getFirst();
    }
}

