/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.common.security.jwt.validator;

import org.activiti.cloud.services.common.security.jwt.validator.AbastractTimeValidationCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.jwt.Jwt;

public class ExpiredValidationCheck
implements AbastractTimeValidationCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExpiredValidationCheck.class);
    private final long offset;

    public ExpiredValidationCheck(long offset) {
        this.offset = offset;
    }

    @Override
    public boolean isValid(Jwt accessToken) {
        boolean result;
        long currentTime = this.currentTime(this.offset);
        boolean bl = result = accessToken.getExpiresAt() == null || accessToken.getExpiresAt().toEpochMilli() == 0L || currentTime <= accessToken.getExpiresAt().toEpochMilli();
        if (!result) {
            LOGGER.debug("Current time {} is greater than expiration time {}", (Object)currentTime, (Object)accessToken.getExpiresAt());
        }
        return result;
    }
}

