/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.security.authorization;

import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.activiti.cloud.security.authorization.AuthorizationProperties;
import org.activiti.cloud.security.authorization.CsrfIgnoreMatcher;
import org.activiti.cloud.security.authorization.CustomAuthorizationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.stereotype.Component;

@Component
public class AuthorizationConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthorizationConfigurer.class);
    private final AuthorizationProperties authorizationProperties;
    private final Environment environment;

    @Autowired
    public AuthorizationConfigurer(AuthorizationProperties authorizationProperties, Environment environment) {
        this.authorizationProperties = authorizationProperties;
        this.environment = environment;
    }

    @PostConstruct
    public void checkKeycloakConfig() {
        String securityConstraintProperty = this.environment.getProperty("keycloak.security-constraints[0].securityCollections[0].patterns[0]");
        if (securityConstraintProperty != null) {
            LOGGER.warn("A Keycloak security configuration was found, it could override Spring Security configuration, please check if we have properties starting with \"keycloak.security-constraints\".");
        }
    }

    public void configure(HttpSecurity http) throws Exception {
        List<AuthorizationProperties.SecurityConstraint> orderedSecurityConstraints = this.getOrderedList(this.authorizationProperties.getSecurityConstraints());
        ArrayList publicUrls = new ArrayList();
        for (AuthorizationProperties.SecurityConstraint securityConstraint : orderedSecurityConstraints) {
            if (!this.hasRoleOrPermissionConstraint(securityConstraint)) {
                List patterns = Arrays.stream(securityConstraint.getSecurityCollections()).flatMap(s -> Arrays.stream(this.getPatterns(s.getPatterns()))).toList();
                publicUrls.addAll(patterns);
            }
            this.configureAuthorization(http, securityConstraint);
        }
        if (!publicUrls.isEmpty()) {
            LOGGER.debug("Disabling CSRF protection for public URLs: {}", publicUrls);
            http.csrf(csrf -> csrf.ignoringRequestMatchers(new RequestMatcher[]{new CsrfIgnoreMatcher(publicUrls)}));
        }
        http.anonymous(Customizer.withDefaults());
    }

    private void configureAuthorization(HttpSecurity http, AuthorizationProperties.SecurityConstraint securityConstraint) throws Exception {
        Consumer<AuthorizeHttpRequestsConfigurer.AuthorizedUrl> authorizedUrlConsumer = this.hasRoleOrPermissionConstraint(securityConstraint) ? a -> a.access(new CustomAuthorizationManager(securityConstraint.getAuthRoles(), securityConstraint.getAuthPermissions())) : AuthorizeHttpRequestsConfigurer.AuthorizedUrl::permitAll;
        this.buildAntMatchers(http, securityConstraint.getSecurityCollections(), authorizedUrlConsumer);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Setting access {} to {}", (Object)securityConstraint.getSecurityCollections(), (Object)(this.hasRoleOrPermissionConstraint(securityConstraint) ? Stream.concat(Arrays.stream(securityConstraint.getAuthRoles()), Arrays.stream(securityConstraint.getAuthPermissions())).collect(Collectors.joining(", ")) : "anonymous"));
        }
    }

    private void buildAntMatchers(HttpSecurity http, AuthorizationProperties.SecurityCollection[] securityCollections, Consumer<AuthorizeHttpRequestsConfigurer.AuthorizedUrl> urlConsumer) throws Exception {
        for (AuthorizationProperties.SecurityCollection securityCollection : securityCollections) {
            String[] patterns = this.getPatterns(securityCollection.getPatterns());
            if (this.isNotEmpty(securityCollection.getOmittedMethods())) {
                List<HttpMethod> methods = this.getAllowedMethods(securityCollection.getOmittedMethods());
                for (HttpMethod method : methods) {
                    http.authorizeHttpRequests(spec -> urlConsumer.accept((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)spec.requestMatchers(method, patterns)));
                }
                continue;
            }
            http.authorizeHttpRequests(spec -> urlConsumer.accept((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)spec.requestMatchers(patterns)));
        }
    }

    private List<HttpMethod> getAllowedMethods(String[] omittedMethods) {
        List<HttpMethod> httpMethods = Stream.of(omittedMethods).map(HttpMethod::valueOf).toList();
        return Stream.of(HttpMethod.values()).filter(Predicate.not(httpMethods::contains)).collect(Collectors.toList());
    }

    private List<AuthorizationProperties.SecurityConstraint> getOrderedList(List<AuthorizationProperties.SecurityConstraint> securityConstraints) {
        ArrayList<AuthorizationProperties.SecurityConstraint> reversed = new ArrayList<AuthorizationProperties.SecurityConstraint>(securityConstraints);
        Collections.reverse(reversed);
        ArrayList<AuthorizationProperties.SecurityConstraint> result = new ArrayList<AuthorizationProperties.SecurityConstraint>();
        reversed.forEach(securityConstraint -> {
            if (this.hasRoleOrPermissionConstraint((AuthorizationProperties.SecurityConstraint)securityConstraint)) {
                result.add((AuthorizationProperties.SecurityConstraint)securityConstraint);
            } else {
                result.addFirst((AuthorizationProperties.SecurityConstraint)securityConstraint);
            }
        });
        return result;
    }

    private String[] getPatterns(String[] patterns) {
        return (String[])Stream.of(patterns).map(pattern -> pattern.endsWith("/*") ? pattern + "*" : pattern).toArray(String[]::new);
    }

    private boolean isNotEmpty(String[] array) {
        return array != null && array.length > 0;
    }

    private boolean hasRoleOrPermissionConstraint(AuthorizationProperties.SecurityConstraint securityConstraint) {
        return this.isNotEmpty(securityConstraint.getAuthRoles()) || this.isNotEmpty(securityConstraint.getAuthPermissions());
    }
}

