/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.alfresco.config;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.activiti.cloud.alfresco.argument.resolver.AlfrescoPageArgumentMethodResolver;
import org.activiti.cloud.alfresco.argument.resolver.AlfrescoPageParameterParser;
import org.activiti.cloud.alfresco.converter.json.AlfrescoJackson2HttpMessageConverter;
import org.activiti.cloud.alfresco.converter.json.PageMetadataConverter;
import org.activiti.cloud.alfresco.converter.json.PagedModelConverter;
import org.activiti.cloud.alfresco.data.domain.AlfrescoPagedModelAssembler;
import org.activiti.cloud.alfresco.data.domain.ExtendedPageMetadataConverter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.PropertySource;
import org.springframework.data.web.HateoasPageableHandlerMethodArgumentResolver;
import org.springframework.data.web.PageableHandlerMethodArgumentResolver;
import org.springframework.hateoas.server.mvc.TypeConstrainedMappingJackson2HttpMessageConverter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.util.UriComponents;

@AutoConfiguration
@PropertySource(value={"classpath:config/alfresco-rest-config.properties"})
public class AlfrescoWebAutoConfiguration
implements WebMvcConfigurer {
    private final PageableHandlerMethodArgumentResolver pageableHandlerMethodArgumentResolver;
    private final int defaultPageSize;
    private final int maxItemsLimit;
    private final boolean maxItemsLimitEnabled;

    public AlfrescoWebAutoConfiguration(@Lazy PageableHandlerMethodArgumentResolver pageableHandlerMethodArgumentResolver, @Value(value="${spring.data.rest.default-page-size:100}") int defaultPageSize, @Value(value="${activiti.cloud.rest.max-items}") int maxItemsLimit, @Value(value="${activiti.cloud.rest.max-items.enabled}") boolean maxItemsLimitEnabled) {
        this.pageableHandlerMethodArgumentResolver = pageableHandlerMethodArgumentResolver;
        this.defaultPageSize = defaultPageSize;
        this.maxItemsLimit = maxItemsLimit;
        this.maxItemsLimitEnabled = maxItemsLimitEnabled;
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
        resolvers.add(0, (HandlerMethodArgumentResolver)new AlfrescoPageArgumentMethodResolver(new AlfrescoPageParameterParser(this.defaultPageSize), this.pageableHandlerMethodArgumentResolver, this.maxItemsLimit, this.maxItemsLimitEnabled));
    }

    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        for (HttpMessageConverter<?> converter : converters) {
            if (!(converter instanceof TypeConstrainedMappingJackson2HttpMessageConverter)) continue;
            ArrayList mediaTypes = new ArrayList(converter.getSupportedMediaTypes());
            mediaTypes.remove(MediaType.APPLICATION_JSON);
            ((TypeConstrainedMappingJackson2HttpMessageConverter)converter).setSupportedMediaTypes(mediaTypes);
        }
    }

    @Bean
    public <T> AlfrescoJackson2HttpMessageConverter<T> alfrescoJackson2HttpMessageConverter(ObjectMapper objectMapper) {
        return new AlfrescoJackson2HttpMessageConverter(new PagedModelConverter(new PageMetadataConverter()), objectMapper);
    }

    @Bean
    public ExtendedPageMetadataConverter extendedPageMetadataConverter() {
        return new ExtendedPageMetadataConverter();
    }

    @Bean
    public <T> AlfrescoPagedModelAssembler<T> alfrescoPagedModelAssembler(@Autowired(required=false) HateoasPageableHandlerMethodArgumentResolver resolver, @Autowired(required=false) UriComponents baseUri, ExtendedPageMetadataConverter extendedPageMetadataConverter) {
        return new AlfrescoPagedModelAssembler(resolver, baseUri, extendedPageMetadataConverter);
    }

    @Bean
    public InitializingBean configureObjectMapperForBigDecimal(ObjectMapper objectMapper) {
        return () -> objectMapper.configOverride(BigDecimal.class).setFormat(JsonFormat.Value.forShape((JsonFormat.Shape)JsonFormat.Shape.STRING));
    }
}

