/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.alfresco.argument.resolver;

import org.springframework.data.domain.AbstractPageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class AlfrescoPageRequest
extends AbstractPageRequest
implements Pageable {
    private final long skipCount;
    private final Pageable pageable;

    public AlfrescoPageRequest(long skipCount, int maxItems, Pageable pageable) {
        super(0, maxItems);
        this.skipCount = skipCount;
        this.pageable = pageable;
    }

    public Sort getSort() {
        return this.pageable.getSort();
    }

    public AlfrescoPageRequest next() {
        return new AlfrescoPageRequest(this.skipCount + (long)this.getPageSize(), this.getPageSize(), this.getPageable());
    }

    public boolean hasPrevious() {
        return this.skipCount > 0L;
    }

    public int getPageNumber() {
        if (this.skipCount % (long)this.getPageSize() == 0L) {
            return Math.toIntExact(this.skipCount / (long)this.getPageSize());
        }
        return Math.toIntExact(this.skipCount / (long)this.getPageSize()) + 1;
    }

    public AlfrescoPageRequest previous() {
        if (this.skipCount == 0L) {
            return this;
        }
        int nextPageSize = this.getPageSize();
        long newSkipCount = this.skipCount - (long)this.getPageSize();
        if (newSkipCount < 0L) {
            newSkipCount = 0L;
            nextPageSize = Math.toIntExact(this.skipCount);
        }
        return new AlfrescoPageRequest(newSkipCount, nextPageSize, this.getPageable());
    }

    public AlfrescoPageRequest first() {
        long remainder = this.skipCount % (long)this.getPageSize();
        int pageSize = Math.toIntExact(remainder == 0L ? (long)this.getPageSize() : remainder);
        return new AlfrescoPageRequest(0L, pageSize, this.getPageable());
    }

    public Pageable withPage(int pageNumber) {
        if (pageNumber < 0) {
            throw new IllegalArgumentException(String.format("Invalid request of a pageNumber %d. pageNumber must be a non negative number", pageNumber));
        }
        return new AlfrescoPageRequest((long)pageNumber * (long)this.getPageSize(), this.getPageSize(), this.getPageable());
    }

    public long getOffset() {
        return this.skipCount;
    }

    public Pageable getPageable() {
        return this.pageable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AlfrescoPageRequest that = (AlfrescoPageRequest)((Object)o);
        if (this.skipCount != that.skipCount) {
            return false;
        }
        return this.pageable != null ? this.pageable.equals((Object)that.pageable) : that.pageable == null;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.skipCount ^ this.skipCount >>> 32);
        result = 31 * result + (this.pageable != null ? this.pageable.hashCode() : 0);
        return result;
    }
}

