/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.events.services;

import java.util.ArrayList;
import org.activiti.api.process.model.IntegrationContext;
import org.activiti.cloud.api.model.shared.impl.events.CloudRuntimeEventImpl;
import org.activiti.cloud.api.process.model.IncidentContext;
import org.activiti.cloud.api.process.model.impl.IncidentContextImpl;
import org.activiti.cloud.api.process.model.impl.events.CloudIncidentCreatedEventImpl;
import org.activiti.cloud.services.events.ProcessEngineChannels;
import org.activiti.cloud.services.events.converter.ExecutionContextInfoAppender;
import org.activiti.cloud.services.events.converter.RuntimeBundleInfoAppender;
import org.activiti.cloud.services.events.message.MessageBuilderChainFactory;
import org.activiti.cloud.services.events.services.SendIncidentEventCmd;
import org.activiti.engine.ManagementService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.impl.context.ExecutionContext;
import org.activiti.engine.impl.interceptor.Command;
import org.springframework.messaging.Message;

public class IncidentService {
    private final ProcessEngineChannels producer;
    private final MessageBuilderChainFactory<ExecutionContext> messageBuilderIncidentsChainFactory;
    private final RuntimeBundleInfoAppender runtimeBundleInfoAppender;
    private final ManagementService managementService;
    private final RuntimeService runtimeService;

    public IncidentService(ProcessEngineChannels producer, MessageBuilderChainFactory<ExecutionContext> messageBuilderIncidentsChainFactory, RuntimeBundleInfoAppender runtimeBundleInfoAppender, ManagementService managementService, RuntimeService runtimeService) {
        this.producer = producer;
        this.messageBuilderIncidentsChainFactory = messageBuilderIncidentsChainFactory;
        this.runtimeBundleInfoAppender = runtimeBundleInfoAppender;
        this.managementService = managementService;
        this.runtimeService = runtimeService;
    }

    public void sendIncidentViaCommand(IntegrationContext integrationContext, Exception exception) {
        Message message = (Message)this.managementService.executeCommand((Command)new SendIncidentEventCmd(integrationContext, exception, this.runtimeService, this.messageBuilderIncidentsChainFactory, this.runtimeBundleInfoAppender));
        this.producer.auditProducer().send(message);
    }

    public void createAndSendIncidentEvent(ExecutionContext rootExecutionContext, Exception exception) {
        ArrayList<CloudIncidentCreatedEventImpl> errorEvents = new ArrayList<CloudIncidentCreatedEventImpl>();
        CloudIncidentCreatedEventImpl incident = this.createCloudIncidentCreatedEvent(rootExecutionContext, exception);
        errorEvents.add(incident);
        Message errorMessage = this.messageBuilderIncidentsChainFactory.create(rootExecutionContext).withPayload(errorEvents).build();
        this.producer.auditProducerIncidents().send(errorMessage);
    }

    private CloudIncidentCreatedEventImpl createCloudIncidentCreatedEvent(ExecutionContext rootExecutionContext, Exception exception) {
        IncidentContextImpl incidentContext = new IncidentContextImpl();
        incidentContext.setProcessInstanceId(rootExecutionContext.getProcessInstance().getId());
        incidentContext.setProcessDefinitionId(rootExecutionContext.getProcessDefinition().getId());
        incidentContext.setActivityId(rootExecutionContext.getProcessInstance().getActivityId());
        incidentContext.setExecutionId(rootExecutionContext.getExecution().getId());
        CloudIncidentCreatedEventImpl incident = new CloudIncidentCreatedEventImpl((Throwable)exception, (IncidentContext)incidentContext);
        this.getExecutionContextInfoAppender(rootExecutionContext).appendExecutionContextInfoTo((CloudRuntimeEventImpl<?, ?>)incident);
        this.runtimeBundleInfoAppender.appendRuntimeBundleInfoTo((CloudRuntimeEventImpl<?, ?>)incident);
        return incident;
    }

    private ExecutionContextInfoAppender getExecutionContextInfoAppender(ExecutionContext rootExecutionContext) {
        return new ExecutionContextInfoAppender(rootExecutionContext);
    }
}

