/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import java.util.Optional;
import org.activiti.api.model.shared.model.VariableInstance;
import org.activiti.cloud.api.model.shared.events.CloudVariableDeletedEvent;
import org.activiti.cloud.services.query.events.handlers.EntityManagerFinder;
import org.activiti.cloud.services.query.model.TaskEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskVariableDeletedEventHandler {
    private static Logger LOGGER = LoggerFactory.getLogger(TaskVariableDeletedEventHandler.class);
    private final EntityManager entityManager;
    private final EntityManagerFinder entityManagerFinder;

    public TaskVariableDeletedEventHandler(EntityManager entityManager, EntityManagerFinder entityManagerFinder) {
        this.entityManager = entityManager;
        this.entityManagerFinder = entityManagerFinder;
    }

    public void handle(CloudVariableDeletedEvent event) {
        String variableName = ((VariableInstance)event.getEntity()).getName();
        String taskId = ((VariableInstance)event.getEntity()).getTaskId();
        Optional<TaskEntity> findResult = this.entityManagerFinder.findTaskWithVariables(taskId);
        if (findResult.isPresent() && !findResult.get().isInFinalState()) {
            try {
                TaskEntity taskEntity = findResult.get();
                taskEntity.getVariable(variableName).ifPresentOrElse(variableEntity -> {
                    taskEntity.getVariables().remove(variableEntity);
                    this.entityManager.remove(variableEntity);
                }, () -> LOGGER.debug("Unable to find variableEntity with name '" + variableName + "' for task instance '" + taskId + "'"));
            }
            catch (Exception cause) {
                LOGGER.debug("Error handling TaskVariableDeletedEvent[" + String.valueOf(event) + "]", (Throwable)cause);
            }
        }
    }
}

