/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import org.activiti.api.model.shared.model.VariableInstance;
import org.activiti.cloud.api.model.shared.events.CloudVariableCreatedEvent;
import org.activiti.cloud.api.model.shared.events.CloudVariableEvent;
import org.activiti.cloud.services.query.events.handlers.EntityManagerFinder;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity;
import org.activiti.cloud.services.query.model.QueryException;
import org.activiti.cloud.services.query.model.TaskEntity;
import org.activiti.cloud.services.query.model.TaskVariableEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskVariableCreatedEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskVariableCreatedEventHandler.class);
    private final EntityManagerFinder entityManagerFinder;
    private final EntityManager entityManager;

    public TaskVariableCreatedEventHandler(EntityManager entityManager, EntityManagerFinder entityManagerFinder) {
        this.entityManagerFinder = entityManagerFinder;
        this.entityManager = entityManager;
    }

    public void handle(CloudVariableCreatedEvent variableCreatedEvent) {
        ProcessInstanceEntity processInstanceEntity = this.getProcessInstance(variableCreatedEvent);
        String taskId = ((VariableInstance)variableCreatedEvent.getEntity()).getTaskId();
        String variableName = ((VariableInstance)variableCreatedEvent.getEntity()).getName();
        this.entityManagerFinder.findTaskWithVariables(taskId).ifPresentOrElse(taskEntity -> taskEntity.getVariable(variableName).ifPresentOrElse(variableEntity -> LOGGER.warn("Variable " + variableName + " already exists in the task " + taskId + "!"), () -> {
            TaskVariableEntity taskVariableEntity = this.createTaskVariableEntity(variableCreatedEvent, (TaskEntity)taskEntity, processInstanceEntity);
            taskEntity.getVariables().add(taskVariableEntity);
        }), () -> {
            throw new QueryException("Task '" + taskId + "' not found!");
        });
    }

    private TaskVariableEntity createTaskVariableEntity(CloudVariableCreatedEvent variableCreatedEvent, TaskEntity taskEntity, ProcessInstanceEntity processInstanceEntity) {
        TaskVariableEntity taskVariableEntity = new TaskVariableEntity((CloudVariableEvent)variableCreatedEvent);
        taskVariableEntity.setValue(((VariableInstance)variableCreatedEvent.getEntity()).getValue());
        taskVariableEntity.setProcessInstance(processInstanceEntity);
        taskVariableEntity.setTask(taskEntity);
        this.entityManager.persist((Object)taskVariableEntity);
        return taskVariableEntity;
    }

    private ProcessInstanceEntity getProcessInstance(CloudVariableCreatedEvent variableCreatedEvent) {
        if (((VariableInstance)variableCreatedEvent.getEntity()).getProcessInstanceId() == null) {
            return null;
        }
        return (ProcessInstanceEntity)this.entityManager.getReference(ProcessInstanceEntity.class, (Object)((VariableInstance)variableCreatedEvent.getEntity()).getProcessInstanceId());
    }
}

