/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import java.util.Optional;
import org.activiti.api.process.model.BPMNActivity;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.process.model.events.CloudBPMNActivityEvent;
import org.activiti.cloud.services.query.model.BPMNActivityEntity;
import org.activiti.cloud.services.query.model.BaseBPMNActivityEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseBPMNActivityEventHandler {
    Logger logger = LoggerFactory.getLogger(BaseBPMNActivityEventHandler.class);
    protected final EntityManager entityManager;

    public BaseBPMNActivityEventHandler(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    protected boolean isServiceTaskActivity(CloudBPMNActivityEvent event) {
        BPMNActivity bpmnActivity = (BPMNActivity)event.getEntity();
        return "serviceTask".equals(bpmnActivity.getActivityType());
    }

    protected Optional<BaseBPMNActivityEntity> findOrCreateBPMNActivityEntity(CloudRuntimeEvent<?, ?> event) {
        this.logger.error("AAE-39414: Handling CloudBPMNActivityEvent");
        CloudBPMNActivityEvent activityEvent = (CloudBPMNActivityEvent)CloudBPMNActivityEvent.class.cast(event);
        BPMNActivity bpmnActivity = (BPMNActivity)activityEvent.getEntity();
        String pkId = BPMNActivityEntity.IdBuilderHelper.from((BPMNActivity)bpmnActivity);
        this.logger.error("AAE-39415: pkId " + pkId);
        BaseBPMNActivityEntity bpmnActivityEntity = null;
        if (!"serviceTask".equals(bpmnActivity.getActivityType())) {
            bpmnActivityEntity = (BaseBPMNActivityEntity)this.entityManager.find(BPMNActivityEntity.class, (Object)pkId);
        }
        if (bpmnActivityEntity == null) {
            return this.createBpmnActivityEntity(event);
        }
        return Optional.of(bpmnActivityEntity);
    }

    public Optional<BaseBPMNActivityEntity> createBpmnActivityEntity(CloudRuntimeEvent<?, ?> event) {
        CloudBPMNActivityEvent activityEvent = (CloudBPMNActivityEvent)CloudBPMNActivityEvent.class.cast(event);
        BPMNActivity bpmnActivity = (BPMNActivity)activityEvent.getEntity();
        String pkId = BPMNActivityEntity.IdBuilderHelper.from((BPMNActivity)bpmnActivity);
        this.logger.error("AAE-39417: Creating new BaseBPMNActivityEntity with pkId: " + pkId);
        BPMNActivityEntity bpmnActivityEntity = null;
        if (!"serviceTask".equals(bpmnActivity.getActivityType())) {
            bpmnActivityEntity = new BPMNActivityEntity(event.getServiceName(), event.getServiceFullName(), event.getServiceVersion(), event.getAppName(), event.getAppVersion());
            bpmnActivityEntity.setId(pkId);
            bpmnActivityEntity.setElementId(bpmnActivity.getElementId());
            bpmnActivityEntity.setActivityName(bpmnActivity.getActivityName());
            bpmnActivityEntity.setActivityType(bpmnActivity.getActivityType());
            bpmnActivityEntity.setProcessDefinitionId(bpmnActivity.getProcessDefinitionId());
            bpmnActivityEntity.setProcessInstanceId(bpmnActivity.getProcessInstanceId());
            bpmnActivityEntity.setExecutionId(bpmnActivity.getExecutionId());
            bpmnActivityEntity.setProcessDefinitionKey(activityEvent.getProcessDefinitionKey());
            bpmnActivityEntity.setProcessDefinitionVersion(activityEvent.getProcessDefinitionVersion());
            bpmnActivityEntity.setBusinessKey(activityEvent.getBusinessKey());
        } else {
            String serviceTaskInfo = "ServiceName: " + event.getServiceName() + ", ServiceFullName: " + event.getServiceFullName() + ", ServiceVersion: " + event.getServiceVersion() + ", AppName: " + event.getAppName() + ", AppVersion: " + event.getAppVersion() + ", ElementId: " + bpmnActivity.getElementId() + ", ActivityName: " + bpmnActivity.getActivityName() + ", ProcessDefinitionId: " + bpmnActivity.getProcessDefinitionId() + ", ProcessInstanceId: " + bpmnActivity.getProcessInstanceId() + ", ExecutionId: " + bpmnActivity.getExecutionId() + ", ProcessDefinitionKey: " + activityEvent.getProcessDefinitionKey() + ", ProcessDefinitionVersion: " + activityEvent.getProcessDefinitionVersion() + ", BusinessKey: " + activityEvent.getBusinessKey();
            this.logger.error("AAE-39416: Should create new ServiceTask: " + serviceTaskInfo);
        }
        return Optional.ofNullable(bpmnActivityEntity);
    }
}

