/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import java.util.Date;
import org.activiti.api.process.model.IntegrationContext;
import org.activiti.api.process.model.events.IntegrationEvent;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.process.model.CloudBPMNActivity;
import org.activiti.cloud.api.process.model.CloudIntegrationContext;
import org.activiti.cloud.api.process.model.events.CloudIntegrationRequestedEvent;
import org.activiti.cloud.services.query.events.handlers.BaseIntegrationEventHandler;
import org.activiti.cloud.services.query.events.handlers.QueryEventHandler;
import org.activiti.cloud.services.query.model.IntegrationContextEntity;
import org.activiti.cloud.services.query.model.ServiceTaskEntity;

public class IntegrationRequestedEventHandler
extends BaseIntegrationEventHandler
implements QueryEventHandler {
    public IntegrationRequestedEventHandler(EntityManager entityManager) {
        super(entityManager);
    }

    @Override
    public void handle(CloudRuntimeEvent<?, ?> event) {
        CloudIntegrationRequestedEvent integrationEvent = (CloudIntegrationRequestedEvent)CloudIntegrationRequestedEvent.class.cast(event);
        IntegrationContext integrationContext = (IntegrationContext)integrationEvent.getEntity();
        String entityId = integrationContext.getId();
        IntegrationContextEntity entity = (IntegrationContextEntity)this.entityManager.find(IntegrationContextEntity.class, (Object)entityId);
        if (entity == null) {
            entity = new IntegrationContextEntity(event.getServiceName(), event.getServiceFullName(), event.getServiceVersion(), event.getAppName(), event.getAppVersion());
            entity.setId(entityId);
            entity.setClientId(integrationContext.getClientId());
        }
        entity.setClientName(integrationContext.getClientName());
        entity.setClientType(integrationContext.getClientType());
        entity.setConnectorType(integrationContext.getConnectorType());
        entity.setProcessDefinitionId(integrationContext.getProcessDefinitionId());
        entity.setProcessInstanceId(integrationContext.getProcessInstanceId());
        entity.setRootProcessInstanceId(integrationContext.getRootProcessInstanceId());
        entity.setExecutionId(integrationContext.getExecutionId());
        entity.setProcessDefinitionKey(integrationContext.getProcessDefinitionKey());
        entity.setProcessDefinitionVersion(integrationContext.getProcessDefinitionVersion());
        entity.setBusinessKey(integrationContext.getBusinessKey());
        entity.setRequestDate(new Date(integrationEvent.getTimestamp()));
        entity.setStatus(CloudIntegrationContext.IntegrationContextStatus.INTEGRATION_REQUESTED);
        entity.setInBoundVariables(((IntegrationContext)integrationEvent.getEntity()).getInBoundVariables());
        ServiceTaskEntity serviceTaskEntity = this.createServiceTaskEntity(integrationEvent, event);
        entity.setServiceTask(serviceTaskEntity);
        this.entityManager.persist((Object)entity);
    }

    @Override
    public String getHandledEvent() {
        return IntegrationEvent.IntegrationEvents.INTEGRATION_REQUESTED.name();
    }

    public ServiceTaskEntity createServiceTaskEntity(CloudIntegrationRequestedEvent integrationEvent, CloudRuntimeEvent<?, ?> event) {
        IntegrationContext integrationContext = (IntegrationContext)integrationEvent.getEntity();
        ServiceTaskEntity serviceTaskEntity = new ServiceTaskEntity(event.getServiceName(), event.getServiceFullName(), event.getServiceVersion(), event.getAppName(), event.getAppVersion());
        serviceTaskEntity.setId(integrationContext.getId());
        serviceTaskEntity.setElementId(integrationContext.getClientId());
        serviceTaskEntity.setActivityName(integrationContext.getClientName());
        serviceTaskEntity.setActivityType("serviceTask");
        serviceTaskEntity.setProcessDefinitionId(integrationContext.getProcessDefinitionId());
        serviceTaskEntity.setProcessInstanceId(integrationContext.getProcessInstanceId());
        serviceTaskEntity.setExecutionId(integrationContext.getExecutionId());
        serviceTaskEntity.setProcessDefinitionKey(integrationContext.getProcessDefinitionKey());
        serviceTaskEntity.setProcessDefinitionVersion(integrationContext.getProcessDefinitionVersion());
        serviceTaskEntity.setBusinessKey(integrationContext.getBusinessKey());
        serviceTaskEntity.setId(integrationContext.getId());
        serviceTaskEntity.setStatus(CloudBPMNActivity.BPMNActivityStatus.STARTED);
        serviceTaskEntity.setStartedDate(new Date(event.getTimestamp()));
        serviceTaskEntity.setCompletedDate(null);
        return serviceTaskEntity;
    }
}

