/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import java.util.Date;
import java.util.Optional;
import org.activiti.api.process.model.IntegrationContext;
import org.activiti.api.process.model.events.IntegrationEvent;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.process.model.CloudBPMNActivity;
import org.activiti.cloud.api.process.model.CloudIntegrationContext;
import org.activiti.cloud.api.process.model.events.CloudIntegrationEvent;
import org.activiti.cloud.api.process.model.events.CloudIntegrationResultReceivedEvent;
import org.activiti.cloud.services.query.events.handlers.BaseIntegrationEventHandler;
import org.activiti.cloud.services.query.events.handlers.QueryEventHandler;
import org.activiti.cloud.services.query.model.IntegrationContextEntity;
import org.activiti.cloud.services.query.model.ServiceTaskEntity;

public class IntegrationResultReceivedEventHandler
extends BaseIntegrationEventHandler
implements QueryEventHandler {
    public IntegrationResultReceivedEventHandler(EntityManager entityManager) {
        super(entityManager);
    }

    @Override
    public void handle(CloudRuntimeEvent<?, ?> event) {
        CloudIntegrationResultReceivedEvent integrationEvent = (CloudIntegrationResultReceivedEvent)CloudIntegrationResultReceivedEvent.class.cast(event);
        Optional<IntegrationContextEntity> integrationContextEntity = this.findIntegrationContextEntity((CloudIntegrationEvent)integrationEvent);
        integrationContextEntity.ifPresent(entity -> {
            entity.setResultDate(new Date(integrationEvent.getTimestamp()));
            entity.setStatus(CloudIntegrationContext.IntegrationContextStatus.INTEGRATION_RESULT_RECEIVED);
            entity.setOutBoundVariables(((IntegrationContext)integrationEvent.getEntity()).getOutBoundVariables());
            this.entityManager.persist(entity);
            ServiceTaskEntity serviceTask = entity.getServiceTask();
            if (serviceTask != null) {
                serviceTask.setCompletedDate(new Date(integrationEvent.getTimestamp()));
                serviceTask.setStatus(CloudBPMNActivity.BPMNActivityStatus.COMPLETED);
                this.entityManager.persist((Object)serviceTask);
            }
        });
    }

    @Override
    public String getHandledEvent() {
        return IntegrationEvent.IntegrationEvents.INTEGRATION_RESULT_RECEIVED.name();
    }
}

