/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import java.util.Date;
import java.util.Optional;
import org.activiti.api.process.model.events.BPMNActivityEvent;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.process.model.CloudBPMNActivity;
import org.activiti.cloud.api.process.model.events.CloudBPMNActivityCompletedEvent;
import org.activiti.cloud.services.query.events.handlers.BaseBPMNActivityEventHandler;
import org.activiti.cloud.services.query.events.handlers.QueryEventHandler;
import org.activiti.cloud.services.query.model.BaseBPMNActivityEntity;

public class BPMNActivityCompletedEventHandler
extends BaseBPMNActivityEventHandler
implements QueryEventHandler {
    public BPMNActivityCompletedEventHandler(EntityManager entityManager) {
        super(entityManager);
    }

    @Override
    public void handle(CloudRuntimeEvent<?, ?> event) {
        CloudBPMNActivityCompletedEvent activityEvent = (CloudBPMNActivityCompletedEvent)CloudBPMNActivityCompletedEvent.class.cast(event);
        Optional<BaseBPMNActivityEntity> optionalBaseBPMNActivityEntity = this.findOrCreateBPMNActivityEntity(event);
        optionalBaseBPMNActivityEntity.ifPresent(bpmnActivityEntity -> {
            bpmnActivityEntity.setCompletedDate(new Date(activityEvent.getTimestamp()));
            bpmnActivityEntity.setStatus(CloudBPMNActivity.BPMNActivityStatus.COMPLETED);
            this.entityManager.persist(bpmnActivityEntity);
        });
    }

    @Override
    public String getHandledEvent() {
        return BPMNActivityEvent.ActivityEvents.ACTIVITY_COMPLETED.name();
    }
}

